/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility.jdt;

import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;

public class DefaultAnnotationEditFormatterTests
extends AnnotationTestCase {
    public DefaultAnnotationEditFormatterTests(String name) {
        super(name);
    }

    public void testCommaLength() throws Exception {
        DefaultAnnotationEditFormatterTests.assertEquals((int)1, (int)this.commaLength(","));
        DefaultAnnotationEditFormatterTests.assertEquals((int)1, (int)this.commaLength(", "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)1, (int)this.commaLength(",   "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)2, (int)this.commaLength(" ,"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)2, (int)this.commaLength(" , "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)2, (int)this.commaLength(" ,   "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)3, (int)this.commaLength("  ,"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)3, (int)this.commaLength("  , "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)3, (int)this.commaLength("  ,   "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,,,"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,,, "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,   ,"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,x"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,x "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("  ,   x"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("x  ,"));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("x  , "));
        DefaultAnnotationEditFormatterTests.assertEquals((int)0, (int)this.commaLength("x  ,   "));
    }

    private int commaLength(String s) {
        Integer len = (Integer)ReflectionTools.executeMethod((Object)DefaultAnnotationEditFormatter.instance(), (String)"commaLength", String.class, (Object)s);
        return len;
    }

    public void testStringIsAnnotation() throws Exception {
        DefaultAnnotationEditFormatterTests.assertTrue((boolean)this.stringIsAnnotation("@F"));
        DefaultAnnotationEditFormatterTests.assertTrue((boolean)this.stringIsAnnotation("@Foo"));
        DefaultAnnotationEditFormatterTests.assertTrue((boolean)this.stringIsAnnotation("@org.bar.Foo"));
        DefaultAnnotationEditFormatterTests.assertFalse((boolean)this.stringIsAnnotation(""));
        DefaultAnnotationEditFormatterTests.assertFalse((boolean)this.stringIsAnnotation("@"));
        DefaultAnnotationEditFormatterTests.assertFalse((boolean)this.stringIsAnnotation("Foo"));
        DefaultAnnotationEditFormatterTests.assertFalse((boolean)this.stringIsAnnotation("Foo@"));
    }

    private boolean stringIsAnnotation(String s) {
        Boolean b = (Boolean)ReflectionTools.executeMethod((Object)DefaultAnnotationEditFormatter.instance(), (String)"stringIsAnnotation", String.class, (Object)s);
        return b;
    }
}

