/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbCoreContextModelTests;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.ELJaxbCoreResourceModelTests;

public class ELJaxbCoreTests {
    public static Test suite() {
        TestSuite suite = new TestSuite(ELJaxbCoreTests.class.getPackage().getName());
        suite.addTest(ELJaxbCoreResourceModelTests.suite());
        suite.addTest(ELJaxbCoreContextModelTests.suite());
        return suite;
    }

    public static boolean requiredJarsExists() {
        return ELJaxbCoreTests.jaxbJarPropertyExists() && ELJaxbCoreTests.jaxbJarFileExists() && ELJaxbCoreTests.eclipselinkJarPropertyExists() && ELJaxbCoreTests.eclipselinkJarFileExists();
    }

    public static boolean jaxbJarPropertyExists() {
        return ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar") != null;
    }

    public static boolean jaxbJarFileExists() {
        return new File(ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar")).exists();
    }

    public static boolean eclipselinkJarPropertyExists() {
        return ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.eclipselink.jar") != null;
    }

    public static boolean eclipselinkJarFileExists() {
        return new File(ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.eclipselink.jar")).exists();
    }

    public static String buildMissingJarErrorMessage() {
        if (!ELJaxbCoreTests.jaxbJarPropertyExists()) {
            return ELJaxbCoreTests.errorMissingProperty("org.eclipse.jpt.jaxb.jar");
        }
        if (!ELJaxbCoreTests.jaxbJarFileExists()) {
            return ELJaxbCoreTests.errorJarFileDoesNotExist(ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar"));
        }
        if (!ELJaxbCoreTests.eclipselinkJarPropertyExists()) {
            return ELJaxbCoreTests.errorMissingProperty("org.eclipse.jpt.eclipselink.jar");
        }
        return ELJaxbCoreTests.errorJarFileDoesNotExist(ELJaxbCoreTests.getSystemProperty("org.eclipse.jpt.eclipselink.jar"));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private ELJaxbCoreTests() {
        throw new UnsupportedOperationException();
    }
}

