/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlAnyElementMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlAnyElementMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlAnyElementMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAnyElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement");
            }
        });
    }

    public void testModifyXmlPath() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAnyElementMapping mapping = (ELJavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNull((Object)mapping.getXmlPath());
        mapping.addXmlPath();
        ELJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNotNull((Object)mapping.getXmlPath());
        mapping.removeXmlPath();
        ELJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNull((Object)mapping.getXmlPath());
    }

    public void testUpdateXmlPath() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAnyElementMapping mapping = (ELJavaXmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNull((Object)mapping.getXmlPath());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlAnyElementMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNotNull((Object)mapping.getXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlAnyElementMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAnyElementMappingTests.assertNull((Object)mapping.getXmlPath());
    }
}

