/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.eclipselink.core.ELJaxbPlatform;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlJoinNodeTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlJoinNodeTests(String name) {
        super(name);
    }

    @Override
    protected JaxbPlatformDescription getPlatform() {
        return ELJaxbPlatform.VERSION_2_2;
    }

    private ICompilationUnit createTypeWithXmlJoinNode() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlJoinNode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNode");
            }
        });
    }

    public void testModifyXmlPath() throws Exception {
        this.createTypeWithXmlJoinNode();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELXmlJoinNodesMapping mapping = (ELXmlJoinNodesMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlJoinNode xmlJoinNode = (ELXmlJoinNode)CollectionTools.get((Iterable)mapping.getXmlJoinNodes(), (int)0);
        XmlJoinNodeAnnotation annotation = (XmlJoinNodeAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getXmlPath());
        xmlJoinNode.setXmlPath("foo");
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)xmlJoinNode.getXmlPath());
        xmlJoinNode.setXmlPath("");
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)xmlJoinNode.getXmlPath());
        xmlJoinNode.setXmlPath(null);
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getXmlPath());
    }

    public void testUpdateXmlPath() throws Exception {
        this.createTypeWithXmlJoinNode();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlJoinNodesMapping mapping = (ELJavaXmlJoinNodesMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlJoinNode xmlJoinNode = (ELXmlJoinNode)CollectionTools.get((Iterable)mapping.getXmlJoinNodes(), (int)0);
        XmlJoinNodeAnnotation annotation = (XmlJoinNodeAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getXmlPath());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "xmlPath", "foo");
            }
        });
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)xmlJoinNode.getXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "xmlPath", "");
            }
        });
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)xmlJoinNode.getXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "xmlPath");
            }
        });
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getXmlPath());
    }

    public void testModifyReferencedXmlPath() throws Exception {
        this.createTypeWithXmlJoinNode();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELXmlJoinNodesMapping mapping = (ELXmlJoinNodesMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlJoinNode xmlJoinNode = (ELXmlJoinNode)CollectionTools.get((Iterable)mapping.getXmlJoinNodes(), (int)0);
        XmlJoinNodeAnnotation annotation = (XmlJoinNodeAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getReferencedXmlPath());
        xmlJoinNode.setReferencedXmlPath("foo");
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)xmlJoinNode.getReferencedXmlPath());
        xmlJoinNode.setReferencedXmlPath("");
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)xmlJoinNode.getReferencedXmlPath());
        xmlJoinNode.setReferencedXmlPath(null);
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getReferencedXmlPath());
    }

    public void testUpdateReferencedXmlPath() throws Exception {
        this.createTypeWithXmlJoinNode();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlJoinNodesMapping mapping = (ELJavaXmlJoinNodesMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlJoinNode xmlJoinNode = (ELXmlJoinNode)CollectionTools.get((Iterable)mapping.getXmlJoinNodes(), (int)0);
        XmlJoinNodeAnnotation annotation = (XmlJoinNodeAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getReferencedXmlPath());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "referencedXmlPath", "foo");
            }
        });
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"foo", (String)xmlJoinNode.getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "referencedXmlPath", "");
            }
        });
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertEquals((String)"", (String)xmlJoinNode.getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodeTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNode", "referencedXmlPath");
            }
        });
        ELJavaXmlJoinNodeTests.assertNull((Object)annotation.getReferencedXmlPath());
        ELJavaXmlJoinNodeTests.assertNull((Object)xmlJoinNode.getReferencedXmlPath());
    }
}

