/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.eclipselink.core.ELJaxbPlatform;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlJoinNodesMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlJoinNodesMappingTests(String name) {
        super(name);
    }

    @Override
    protected JaxbPlatformDescription getPlatform() {
        return ELJaxbPlatform.VERSION_2_2;
    }

    private ICompilationUnit createTypeWithXmlJoinNodes() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlJoinNodes"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNodes");
            }
        });
    }

    protected NormalAnnotation newXmlJoinNodeAnnotation(AST ast, String xmlPath, String referencedXmlPath) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        this.addMemberValuePair(annotation, "xmlPath", xmlPath);
        this.addMemberValuePair(annotation, "referencedXmlPath", referencedXmlPath);
        return annotation;
    }

    protected void addXmlJoinNode(ModifiedDeclaration declaration, int index, String xmlPath, String referencedXmlPath) {
        NormalAnnotation annotation = this.newXmlJoinNodeAnnotation(declaration.getAst(), xmlPath, referencedXmlPath);
        this.addArrayElement(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNodes", index, "value", (Expression)annotation);
    }

    protected void moveXmlJoinNode(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlJoinNodes"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlJoinNode(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlJoinNodes"), "value", index);
    }

    public void testUpdateXmlJoinNodes() throws Exception {
        this.createTypeWithXmlJoinNodes();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        ELXmlJoinNodesMapping mapping = (ELXmlJoinNodesMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.addXmlJoinNode(declaration, 0, "foo", "@foo");
                ELJavaXmlJoinNodesMappingTests.this.addXmlJoinNode(declaration, 1, "bar", "@bar");
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertFalse((boolean)CollectionTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)2, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)1)).getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.moveXmlJoinNode(declaration, 0, 1);
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertFalse((boolean)CollectionTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)2, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((ELXmlJoinNode)CollectionTools.get((Iterable)xmlJoinNodes, (int)1)).getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.removeXmlJoinNode(declaration, 1);
                ELJavaXmlJoinNodesMappingTests.this.removeXmlJoinNode(declaration, 0);
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
    }

    public void testModifyXmlJoinNodes() throws Exception {
        this.createTypeWithXmlJoinNodes();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        ELXmlJoinNodesMapping mapping = (ELXmlJoinNodesMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
        ELXmlJoinNode joinNode = mapping.addXmlJoinNode(0);
        joinNode.setXmlPath("foo");
        joinNode.setReferencedXmlPath("@foo");
        joinNode = mapping.addXmlJoinNode(1);
        joinNode.setXmlPath("baz");
        joinNode.setReferencedXmlPath("@baz");
        joinNode = mapping.addXmlJoinNode(1);
        joinNode.setXmlPath("bar");
        joinNode.setReferencedXmlPath("@bar");
        SubIterableWrapper xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"baz", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@baz", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getReferencedXmlPath());
        mapping.moveXmlJoinNode(1, 2);
        xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"baz", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@baz", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((XmlJoinNodeAnnotation)CollectionTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getReferencedXmlPath());
        mapping.removeXmlJoinNode(2);
        mapping.removeXmlJoinNode(0);
        mapping.removeXmlJoinNode(0);
        xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
    }
}

