/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericContextRootTests
extends JaxbContextModelTestCase {
    public GenericContextRootTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorOrder() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)", new String[]{"javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
    }

    private ICompilationUnit createClassWithXmlTypeAndSuperclassNamed(final String superclassName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends " + superclassName);
            }
        });
    }

    private ICompilationUnit createClassWithXmlTypeAndAttribute(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public " + typeName + " " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createClassWithXmlTypeAndListAttribute(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"java.util.List", "javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public List<" + typeName + "> " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    public void testGetPackages() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        Iterator packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        this.createUnannotatedPackageInfo("foo");
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        JavaResourcePackage fooResourcePackage = this.getJaxbProject().getJavaResourcePackage("foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlAccessorTypeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
            }
        });
        TransformationIterable<JaxbPackage, String> packageNames = new TransformationIterable<JaxbPackage, String>(this.getContextRoot().getPackages()){

            protected String transform(JaxbPackage o) {
                return o.getName();
            }
        };
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)packageNames, (Object)"test"));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)packageNames, (Object)"foo"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeXmlAccessorTypeAnnotation(declaration);
            }
        });
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
    }

    protected void addXmlAccessorTypeAnnotation(ModifiedDeclaration declaration, String accessType) {
        NormalAnnotation annotation = this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorType");
        this.addEnumMemberValuePair(annotation, "value", accessType);
    }

    protected void removeXmlAccessorTypeAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
    }

    protected void addXmlSeeAlsoAnnotation(final ModifiedDeclaration declaration, String ... typeNames) {
        Annotation annotation = declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSeeAlso");
        NormalAnnotation normalAnnotation = null;
        normalAnnotation = annotation == null ? this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSeeAlso") : (annotation.isMarkerAnnotation() ? this.replaceMarkerAnnotation((MarkerAnnotation)annotation) : (NormalAnnotation)annotation);
        ArrayInitializer arrayInitializer = this.newArrayInitializer(declaration.getAst(), (Expression[])ArrayTools.array((Iterable)new TransformationIterable<String, TypeLiteral>((Iterable)new ArrayIterable((Object[])typeNames)){

            protected TypeLiteral transform(String o) {
                return GenericContextRootTests.this.newTypeLiteral(declaration.getAst(), o);
            }
        }, (Object[])new Expression[0]));
        this.addMemberValuePair(normalAnnotation, "value", (Expression)arrayInitializer);
    }

    public void testGetRegistries() throws Exception {
        this.createClassWithXmlRegistry();
        Iterable types = this.getContextRoot().getTypes();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")).getXmlRegistry());
        this.createUnannotatedClassNamed("Foo");
        types = this.getContextRoot().getTypes();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")).getXmlRegistry());
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        types = this.getContextRoot().getTypes();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.Foo")).getXmlRegistry());
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")).getXmlRegistry());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        types = this.getContextRoot().getTypes();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")).getXmlRegistry());
    }

    public void testGetTypes() throws Exception {
        this.createClassWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        this.createUnannotatedClassNamed("Foo");
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.Foo")));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNull((Object)((JaxbClass)this.getContextRoot().getType("test.Foo")));
    }

    public void testGetTypes2() throws Exception {
        this.createEnumWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbEnum)this.getContextRoot().getType("test.AnnotationTestType")));
        this.createUnannotatedEnumNamed("Foo");
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbEnum)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNull((Object)((JaxbEnum)this.getContextRoot().getType("test.Foo")));
        JavaResourceEnum fooResourceType = (JavaResourceEnum)this.getJaxbProject().getJavaResourceType("test.Foo", JavaResourceAnnotatedElement.Kind.ENUM);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbEnum)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNotNull((Object)((JaxbEnum)this.getContextRoot().getType("test.Foo")));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbEnum)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNull((Object)((JaxbEnum)this.getContextRoot().getType("test.Foo")));
    }

    public void testDirectReferencedSuperclass() throws Exception {
        String superclassName = "SuperAnnotationTestType";
        String fqSuperclassName = "test." + superclassName;
        this.createUnannotatedClassNamed(superclassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        this.createClassWithXmlTypeAndSuperclassNamed(superclassName);
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNotNull((Object)((JaxbClass)this.getContextRoot().getType(fqSuperclassName)));
        IFile file = (IFile)this.getContextRoot().getType("test.AnnotationTestType").getResource();
        file.delete(true, null);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNull((Object)((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType")));
        GenericContextRootTests.assertNull((Object)((JaxbClass)this.getContextRoot().getType(fqSuperclassName)));
    }

    public void testDirectReferencedAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        this.createClassWithXmlTypeAndAttribute(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getType(fqOtherClassName));
    }

    public void testDirectReferencedListAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        this.createClassWithXmlTypeAndListAttribute(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getType(fqOtherClassName));
    }

    public void testDirectReferencedSeeAlso() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        this.createClassWithXmlType();
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        AnnotatedElement annotatedType = this.annotatedElement((JavaResourceAnnotatedElement)thisType);
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType", "OtherAnnotationTestType2");
            }
        });
        GenericContextRootTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType2"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
    }

    public void testJaxbIndex() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getTypes()));
        this.createClassWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        IFile jaxbIndex = this.getJavaProject().getProject().getFile((IPath)new Path("src/test/jaxb.index"));
        ByteArrayInputStream stream = new ByteArrayInputStream("OtherAnnotationTestType".getBytes());
        jaxbIndex.create((InputStream)stream, true, null);
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(("OtherAnnotationTestType" + CR + "OtherAnnotationTestType2").getBytes()), true, false, null);
        GenericContextRootTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.OtherAnnotationTestType2"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getType("test.AnnotationTestType"));
    }
}

