/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaElementFactoryMethodTests
extends JaxbContextModelTestCase {
    public GenericJavaElementFactoryMethodTests(String name) {
        super(name);
    }

    protected ICompilationUnit createClassWithXmlRegistryAndCreateMethods() throws Exception {
        return this.createTestType("test", "ObjectFactory.java", "ObjectFactory", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRegistry", "javax.xml.bind.annotation.XmlElementDecl", "javax.xml.bind.JAXBElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRegistry");
            }

            public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl").append(CR);
                sb.append("    JAXBElement<AnnotationTestType> createFoo(AnnotationTestType value) {return null}").append(CR);
                sb.append(CR);
                sb.append("    @XmlElementDecl(name=\"bar\")").append(CR);
                sb.append("    JAXBElement createBar(Object value) {return null}").append(CR);
                sb.append(CR);
            }
        });
    }

    public void testModifyElementName() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getQName().getName());
        elementFactoryMethod.getQName().setSpecifiedName("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getName());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod.getQName().setSpecifiedName(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getName());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getQName().getName());
    }

    public void testUpdateElementName() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyDefaultValue() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
        elementFactoryMethod.setDefaultValue("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getDefaultValue());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getDefaultValue());
        elementFactoryMethod.setDefaultValue(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getDefaultValue());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
    }

    public void testUpdateDefaultValue() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getDefaultValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "defaultValue", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getDefaultValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyScope() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
        GenericJavaElementFactoryMethodTests.assertTrue((boolean)elementFactoryMethod.isGlobalScope());
        elementFactoryMethod.setScope("Bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Bar", (String)elementDeclAnnotation.getScope());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Bar", (String)elementFactoryMethod.getScope());
        GenericJavaElementFactoryMethodTests.assertFalse((boolean)elementFactoryMethod.isGlobalScope());
        elementFactoryMethod.setScope("javax.xml.bind.annotation.XmlElementDecl.GLOBAL");
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"javax.xml.bind.annotation.XmlElementDecl.GLOBAL", (String)elementDeclAnnotation.getScope());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"javax.xml.bind.annotation.XmlElementDecl.GLOBAL", (String)elementFactoryMethod.getScope());
        GenericJavaElementFactoryMethodTests.assertTrue((boolean)elementFactoryMethod.isGlobalScope());
        elementFactoryMethod.setScope(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getScope());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
    }

    public void testUpdateScope() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getScope());
        GenericJavaElementFactoryMethodTests.assertTrue((boolean)elementFactoryMethod.isGlobalScope());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclTypeMemberValuePair(declaration, "scope", "Foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"Foo", (String)elementFactoryMethod.getScope());
        GenericJavaElementFactoryMethodTests.assertFalse((boolean)elementFactoryMethod.isGlobalScope());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    public void testModifySubstitutionHeadName() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadQName().getName());
        elementFactoryMethod.getSubstitutionHeadQName().setSpecifiedName("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getSubstitutionHeadName());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getSubstitutionHeadQName().getName());
        elementFactoryMethod.getSubstitutionHeadQName().setSpecifiedName(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getSubstitutionHeadName());
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadQName().getName());
    }

    public void testUpdateSubstitutionHeadName() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementFactoryMethod.getSubstitutionHeadQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "substitutionHeadName", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getSubstitutionHeadQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    public void testModifySubstitutionHeadNamespace() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getSubstitutionHeadQName().getNamespace());
        elementFactoryMethod.getSubstitutionHeadQName().setSpecifiedNamespace("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getSubstitutionHeadNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getSubstitutionHeadQName().getNamespace());
        elementFactoryMethod.getSubstitutionHeadQName().setSpecifiedNamespace(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getSubstitutionHeadNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getSubstitutionHeadQName().getNamespace());
    }

    public void testUpdateSubstitutionHeadNamespace() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getSubstitutionHeadQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "substitutionHeadNamespace", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getSubstitutionHeadQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    public void testModifyNamespace() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getQName().getNamespace());
        elementFactoryMethod.getQName().setSpecifiedNamespace("bar");
        XmlElementDeclAnnotation elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementDeclAnnotation.getNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getNamespace());
        elementFactoryMethod.getQName().setSpecifiedNamespace(null);
        elementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        GenericJavaElementFactoryMethodTests.assertNull((Object)elementDeclAnnotation.getNamespace());
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getQName().getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.ObjectFactory");
        XmlRegistry xmlRegistry = jaxbClass.getXmlRegistry();
        GenericJavaElementFactoryMethodTests.assertEquals((int)2, (int)xmlRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = xmlRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        JavaResourceMethod resourceMethod = elementFactoryMethod.getResourceMethod();
        GenericJavaElementFactoryMethodTests.assertEquals((String)"", (String)elementFactoryMethod.getQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.addXmlElementDeclMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((String)"foo", (String)elementFactoryMethod.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaElementFactoryMethodTests.this.removeXmlElementDeclAnnotation(declaration);
            }
        });
        GenericJavaElementFactoryMethodTests.assertEquals((int)1, (int)xmlRegistry.getElementFactoryMethodsSize());
    }

    protected void addXmlElementDeclMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementDeclAnnotation(declaration), name, value);
    }

    protected Annotation getXmlElementDeclAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementDecl");
    }

    protected void removeXmlElementDeclAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementDecl");
    }

    protected void addXmlElementDeclTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementDeclAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }
}

