/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlRootElementTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlRootElementTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlTypeWithXmlRootElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlRootElement").append(CR);
            }
        });
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlRootElement contextRootElement = classMapping.getXmlRootElement();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getQName().getDefaultNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getQName().getNamespace());
        contextRootElement.getQName().setSpecifiedNamespace("foo");
        XmlRootElementAnnotation rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)rootElementAnnotation.getNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getNamespace());
        contextRootElement.getQName().setSpecifiedNamespace(null);
        rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertNull((Object)rootElementAnnotation.getNamespace());
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getQName().getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlRootElement contextRootElement = classMapping.getXmlRootElement();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getQName().getDefaultNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.addXmlRootElementMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaXmlRootElementTests.assertNull((Object)classMapping.getXmlRootElement());
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlRootElement contextRootElement = classMapping.getXmlRootElement();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getQName().getDefaultName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getQName().getName());
        contextRootElement.getQName().setSpecifiedName("foo");
        XmlRootElementAnnotation rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)rootElementAnnotation.getName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getName());
        contextRootElement.getQName().setSpecifiedName(null);
        rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertNull((Object)rootElementAnnotation.getName());
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getQName().getName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlRootElement contextRootElement = classMapping.getXmlRootElement();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getQName().getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getQName().getDefaultName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.addXmlRootElementMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaXmlRootElementTests.assertNull((Object)classMapping.getXmlRootElement());
    }

    protected void addXmlRootElementMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlRootElementAnnotation(declaration), name, value);
    }

    protected Annotation getXmlRootElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlRootElement");
    }
}

