/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAttributeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ATTRIBUTE_NAME = "elementName";
    private static final String XML_ATTRIBUTE_NAMESPACE = "XmlAttributeNamespace";

    public XmlAttributeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute");
            }
        });
    }

    private ICompilationUnit createTestXmlAttributeWithName() throws Exception {
        return this.createTestXmlAttributeWithStringElement("name", XML_ATTRIBUTE_NAME);
    }

    private ICompilationUnit createTestXmlAttributeWithNamespace() throws Exception {
        return this.createTestXmlAttributeWithStringElement("namespace", XML_ATTRIBUTE_NAMESPACE);
    }

    private ICompilationUnit createTestXmlAttributeWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute(" + element + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestXmlAttributeWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute(" + booleanElement + " = true)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertTrue((xmlAttributeAnnotation != null ? 1 : 0) != 0);
        XmlAttributeAnnotationTests.assertEquals((String)XML_ATTRIBUTE_NAME, (String)xmlAttributeAnnotation.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttribute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertTrue((xmlAttributeAnnotation != null ? 1 : 0) != 0);
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getName());
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getNamespace());
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getRequired());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttribute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getName());
        xmlAttributeAnnotation.setName(XML_ATTRIBUTE_NAME);
        XmlAttributeAnnotationTests.assertEquals((String)XML_ATTRIBUTE_NAME, (String)xmlAttributeAnnotation.getName());
        this.assertSourceContains("@XmlAttribute(name = \"elementName\")", cu);
        xmlAttributeAnnotation.setName(null);
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getName());
        this.assertSourceContains("@XmlAttribute", cu);
        this.assertSourceDoesNotContain("@XmlAttribute(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertTrue((xmlAttributeAnnotation != null ? 1 : 0) != 0);
        XmlAttributeAnnotationTests.assertEquals((String)XML_ATTRIBUTE_NAMESPACE, (String)xmlAttributeAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttribute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getNamespace());
        xmlAttributeAnnotation.setNamespace(XML_ATTRIBUTE_NAMESPACE);
        XmlAttributeAnnotationTests.assertEquals((String)XML_ATTRIBUTE_NAMESPACE, (String)xmlAttributeAnnotation.getNamespace());
        this.assertSourceContains("@XmlAttribute(namespace = \"XmlAttributeNamespace\")", cu);
        xmlAttributeAnnotation.setNamespace(null);
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getNamespace());
        this.assertSourceContains("@XmlAttribute", cu);
        this.assertSourceDoesNotContain("@XmlAttribute(namespace = \"XmlAttributeNamespace\")", cu);
    }

    public void testGetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithBooleanElement("required");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeAnnotation.getRequired());
    }

    public void testSetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttribute();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        XmlAttributeAnnotationTests.assertNotNull((Object)xmlAttributeAnnotation);
        XmlAttributeAnnotationTests.assertNull((Object)xmlAttributeAnnotation.getRequired());
        xmlAttributeAnnotation.setRequired(Boolean.FALSE);
        XmlAttributeAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlAttributeAnnotation.getRequired());
        this.assertSourceContains("@XmlAttribute(required = false)", cu);
        xmlAttributeAnnotation.setRequired(null);
        this.assertSourceContains("@XmlAttribute", cu);
        this.assertSourceDoesNotContain("required", cu);
    }
}

