/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlTransientAttributeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlTransientAttributeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlTransient() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlTransient"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlTransient");
            }
        });
    }

    public void testGetXmlTransient() throws Exception {
        ICompilationUnit cu = this.createTestXmlTransient();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlTransientAnnotation xmlTransientAnnotation = (XmlTransientAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        XmlTransientAttributeAnnotationTests.assertTrue((xmlTransientAnnotation != null ? 1 : 0) != 0);
        resourceMethod.removeAnnotation("javax.xml.bind.annotation.XmlTransient");
        this.assertSourceDoesNotContain("@XmlTransient", cu);
    }
}

