/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;

public class VarargsTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public VarargsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return VarargsTest.buildComparableTestSuite(VarargsTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.VarargsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\t\n\t\tY.count();\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2, (byte) 3, 4);\n\t\tY.count(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic Y(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n\tpublic static void count(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n}\n"}, "<0 0 1 10 10 0 0 1 10 10 >");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\t\n\t\tY.count();\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2, (byte) 3, 4);\n\t\tY.count(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<0 0 1 10 10 0 0 1 10 10 >", null, false, null);
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y extends Z {\n\tpublic Y(int ... values) { super(values); }\n}\nclass Z {\n\tpublic Z(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n}\n"}, "<0 0 1 10 10 >");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<0 0 1 10 10 >", null, false, null);
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count();\n\t\tY.count((int[]) null);\n\t\tY.count((int[][]) null);\n\t\tY.count(new int[] {1});\n\t\tY.count(new int[] {1, 2}, new int[] {3, 4});\n\t\tY.count(new int[][] {new int[] {1, 2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static int count(int[] values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print(result);\n\t\treturn result;\n\t}\n\tpublic static void count(int[] ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += count(values[i]);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(result);\n\t}\n}\n"}, "<=0 0=0 1 3 7=10 6 4=10>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count();\n\t\tY.count((int[]) null);\n\t\tY.count((int[][]) null);\n\t\tY.count(new int[] {1});\n\t\tY.count(new int[] {1, 2}, new int[] {3, 4});\n\t\tY.count(new int[][] {new int[] {1, 2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<=0 0=0 1 3 7=10 6 4=10>", null, false, null);
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(0);\n\t\tY.count(-1, (int[]) null);\n\t\tY.count(-2, (int[][]) null);\n\t\tY.count(1);\n\t\tY.count(2, new int[] {1});\n\t\tY.count(3, new int[] {1}, new int[] {2, 3}, new int[] {4});\n\t\tY.count((byte) 4, new int[][] {new int[] {1}, new int[] {2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static int count(int j, int[] values) {\n\t\tint result = j;\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print('[');\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(']');\n\t\treturn result;\n\t}\n\tpublic static void count(int j, int[] ... values) {\n\t\tint result = j;\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(':');\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += count(j, values[i]);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(result);\n\t}\n}\n"}, "< 0:=0 [-1] -2:=-2 1:=1 [3] 3: [4] [8] [7]=22 4: [5] [9] [8]=26>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(0);\n\t\tY.count(-1, (int[]) null);\n\t\tY.count(-2, (int[][]) null);\n\t\tY.count(1);\n\t\tY.count(2, new int[] {1});\n\t\tY.count(3, new int[] {1}, new int[] {2, 3}, new int[] {4});\n\t\tY.count((byte) 4, new int[][] {new int[] {1}, new int[] {2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "< 0:=0 [-1] -2:=-2 1:=1 [3] 3: [4] [8] [7]=22 4: [5] [9] [8]=26>", null, false, null);
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.print();\n\t\tY.print(new Integer(1));\n\t\tY.print(new Integer(1), new Byte((byte) 3), new Integer(7));\n\t\tY.print(new Integer[] {new Integer(11) });\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void print(Number ... values) {\n\t\tfor (int i = 0, l = values.length; i < l; i++) {\n\t\t\tSystem.out.print(' ');\n\t\t\tSystem.out.print(values[i]);\n\t\t}\n\t\tSystem.out.print(',');\n\t}\n}\n"}, "<, 1, 1 3 7, 11,>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.print();\n\t\tY.print(new Integer(1));\n\t\tY.print(new Integer(1), new Byte((byte) 3), new Integer(7));\n\t\tY.print(new Integer[] {new Integer(11) });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<, 1, 1 3 7, 11,>", null, false, null);
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tString[] T_NAMES = new String[] {\"foo\"};\n\t\tString error = \"error\";\n\t\tY.format(\"E_UNSUPPORTED_CONV\", new Integer(0));\n\t\tY.format(\"E_SAVE\", T_NAMES[0], error);\n\t}\n}\nclass Y {\n\tpublic static String format(String key) { return null; }\n\tpublic static String format(String key, Object ... args) { return null; }\n}\n"}, "");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.byte2(null);\n\t\tY.byte2((byte) 1);\n\t\tY.byte2(new byte[] {});\n\t\tY.byte2(new byte[][] {});\n\t\tY.byte2(new byte[][][] {});\n\n\t\tY.object(null);\n\t\tY.object((byte) 1);\n\t\tY.object(new byte[] {});\n\t\tY.object(new byte[][] {});\n\t\tY.object(new byte[][][] {});\n\n\t\tY.object(new String());\n\t\tY.object(new String[] {});\n\t\tY.object(new String[][] {});\n\n\t\tY.object2(null);\n\t\tY.object2((byte) 1);\n\t\tY.object2(new byte[] {});\n\t\tY.object2(new byte[][] {});\n\t\tY.object2(new byte[][][] {});\n\n\t\tY.object2(new String());\n\t\tY.object2(new String[] {});\n\t\tY.object2(new String[][] {});\n\n\t\tY.string(null);\n\t\tY.string(new String());\n\t\tY.string(new String[] {});\n\t\tY.string(new String[][] {});\n\n\t\tY.string(new Object());\n\t\tY.string(new Object[] {});\n\t\tY.string(new Object[][] {});\n\t}\n}\nclass Y {\n\tpublic static void byte2(byte[] ... values) {}\n\tpublic static void object(Object ... values) {}\n\tpublic static void object2(Object[] ... values) {}\n\tpublic static void string(String ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tY.byte2(null);\n\t^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to byte[][] for the invocation of the varargs method byte2(byte[]...) from type Y. It could alternatively be cast to byte[] for a varargs invocation\n----------\n2. ERROR in X.java (at line 4)\n\tY.byte2((byte) 1);\n\t  ^^^^^\nThe method byte2(byte[]...) in the type Y is not applicable for the arguments (byte)\n----------\n3. ERROR in X.java (at line 7)\n\tY.byte2(new byte[][][] {});\n\t  ^^^^^\nThe method byte2(byte[]...) in the type Y is not applicable for the arguments (byte[][][])\n----------\n4. WARNING in X.java (at line 9)\n\tY.object(null);\n\t^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Object[] for the invocation of the varargs method object(Object...) from type Y. It could alternatively be cast to Object for a varargs invocation\n----------\n5. WARNING in X.java (at line 12)\n\tY.object(new byte[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type byte[][] should explicitly be cast to Object[] for the invocation of the varargs method object(Object...) from type Y. It could alternatively be cast to Object for a varargs invocation\n----------\n6. WARNING in X.java (at line 13)\n\tY.object(new byte[][][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type byte[][][] should explicitly be cast to Object[] for the invocation of the varargs method object(Object...) from type Y. It could alternatively be cast to Object for a varargs invocation\n----------\n7. WARNING in X.java (at line 16)\n\tY.object(new String[] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type String[] should explicitly be cast to Object[] for the invocation of the varargs method object(Object...) from type Y. It could alternatively be cast to Object for a varargs invocation\n----------\n8. WARNING in X.java (at line 17)\n\tY.object(new String[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type String[][] should explicitly be cast to Object[] for the invocation of the varargs method object(Object...) from type Y. It could alternatively be cast to Object for a varargs invocation\n----------\n9. WARNING in X.java (at line 19)\n\tY.object2(null);\n\t^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Object[][] for the invocation of the varargs method object2(Object[]...) from type Y. It could alternatively be cast to Object[] for a varargs invocation\n----------\n10. ERROR in X.java (at line 20)\n\tY.object2((byte) 1);\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (byte)\n----------\n11. ERROR in X.java (at line 21)\n\tY.object2(new byte[] {});\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (byte[])\n----------\n12. WARNING in X.java (at line 23)\n\tY.object2(new byte[][][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type byte[][][] should explicitly be cast to Object[][] for the invocation of the varargs method object2(Object[]...) from type Y. It could alternatively be cast to Object[] for a varargs invocation\n----------\n13. ERROR in X.java (at line 25)\n\tY.object2(new String());\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (String)\n----------\n14. WARNING in X.java (at line 27)\n\tY.object2(new String[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type String[][] should explicitly be cast to Object[][] for the invocation of the varargs method object2(Object[]...) from type Y. It could alternatively be cast to Object[] for a varargs invocation\n----------\n15. WARNING in X.java (at line 29)\n\tY.string(null);\n\t^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to String[] for the invocation of the varargs method string(String...) from type Y. It could alternatively be cast to String for a varargs invocation\n----------\n16. ERROR in X.java (at line 32)\n\tY.string(new String[][] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (String[][])\n----------\n17. ERROR in X.java (at line 34)\n\tY.string(new Object());\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object)\n----------\n18. ERROR in X.java (at line 35)\n\tY.string(new Object[] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object[])\n----------\n19. ERROR in X.java (at line 36)\n\tY.string(new Object[][] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object[][])\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY y = new Y(null);\n\t\ty = new Y(true, null);\n\t\ty = new Y('i', null);\n\t}\n}\nclass Y {\n\tpublic Y(int ... values) {}\n\tpublic Y(boolean b, Object ... values) {}\n\tpublic Y(char c, int[] ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ty = new Y(true, null);\n\t    ^^^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Object[] for the invocation of the varargs constructor Y(boolean, Object...). It could alternatively be cast to Object for a varargs invocation\n----------\n2. WARNING in X.java (at line 5)\n\ty = new Y('i', null);\n\t    ^^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to int[][] for the invocation of the varargs constructor Y(char, int[]...). It could alternatively be cast to int[] for a varargs invocation\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY y = new Y(null);\n\t\ty = new Y(true, null);\n\t\ty = new Y('i', null);\n\t}\n}\nclass Y extends Z {\n\tpublic Y(int ... values) { super(values); }\n\tpublic Y(boolean b, Object ... values) { super(b, values); }\n\tpublic Y(char c, int[] ... values) {}\n}\nclass Z {\n\tpublic Z(int ... values) {}\n\tpublic Z(boolean b, Object ... values) {}\n\tpublic Z(char c, int[] ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ty = new Y(true, null);\n\t    ^^^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Object[] for the invocation of the varargs constructor Y(boolean, Object...). It could alternatively be cast to Object for a varargs invocation\n----------\n2. WARNING in X.java (at line 5)\n\ty = new Y('i', null);\n\t    ^^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to int[][] for the invocation of the varargs constructor Y(char, int[]...). It could alternatively be cast to int[] for a varargs invocation\n----------\n");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2);\n\n\t\tZ.count(1L, 1);\n\t\tZ.count(1, 1);\n\t\tZ.count(1, null);\n\t\tZ.count2(1, null);\n\t\tZ.count2(1L, null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(int values) { System.out.print('1'); }\n\tpublic static void count(int ... values) { System.out.print('2'); }\n}\nclass Z {\n\tpublic static void count(long l, long values) { System.out.print('3'); }\n\tpublic static void count(int i, int ... values) { System.out.print('4'); }\n\tpublic static void count2(int i, int values) { System.out.print('5'); }\n\tpublic static void count2(long l, int ... values) { System.out.print('6'); }\n}\n"}, "<21233466>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.test((Object[]) null);\n\t\tY.test(null, null);\n\t\tY.test(null, null, null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void test(Object o, Object o2) { System.out.print('1'); }\n\tpublic static void test(Object ... values) { System.out.print('2'); }\n}\n"}, "<212>");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count((Object) new Integer(1));\n\t\tY.count(new Integer(1));\n\n\t\tY.count((Object) null);\n\t\tY.count((Object[]) null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(Object values) { System.out.print('1'); }\n\tpublic static void count(Object ... values) { System.out.print('2'); }\n}\n"}, "<1112>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(new Object[] {new Integer(1)});\n\t\tY.count(new Integer[] {new Integer(1)});\n\n\t\tY.count((Object[]) null);\n\t\tY.count((Object[][]) null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(Object[] values) { System.out.print('1'); }\n\tpublic static void count(Object[] ... values) { System.out.print('2'); }\n}\n"}, "<1112>");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.string(null);\n\t\tY.string2(null);\n\t\tY.int2(null);\n\t}\n}\nclass Y {\n\tpublic static void string(String values) { System.out.print('1'); }\n\tpublic static void string(String ... values) { System.out.print('2'); }\n\tpublic static void string2(String[] values) { System.out.print('1'); }\n\tpublic static void string2(String[] ... values) { System.out.print('2'); }\n\tpublic static void int2(int[] values) { System.out.print('1'); }\n\tpublic static void int2(int[] ... values) { System.out.print('2'); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.string(null);\n\t  ^^^^^^\nThe method string(String) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.string2(null);\n\t  ^^^^^^^\nThe method string2(String[]) is ambiguous for the type Y\n----------\n3. ERROR in X.java (at line 5)\n\tY.int2(null);\n\t  ^^^^\nThe method int2(int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void count(int ... values) {} }\nclass Y extends X { void count(int[] values) {} }\nclass Z extends Y { void count(int... values) {} }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass Y extends X { void count(int[] values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike Y.count(int[]) and X.count(int...)\n----------\n2. WARNING in X.java (at line 2)\n\tclass Y extends X { void count(int[] values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^\nThe method count(int[]) of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in X.java (at line 3)\n\tclass Z extends Y { void count(int... values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike Z.count(int...) and Y.count(int[])\n----------\n4. WARNING in X.java (at line 3)\n\tclass Z extends Y { void count(int... values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^\nThe method count(int...) of type Z should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main (String ... args) {\n       for (String a:args) {\n           System.out.println(a);\n       }\n   }\n}\n\n"});
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(long i, int j) { System.out.print(1); }\n\tpublic static void count(int ... values) { System.out.print(2); }\n}\n"}, "1");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0], 1);\n\t\tY.count(new int[0], 1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(1); }\n\tpublic static void count(Object o, int ... values) { System.out.print(2); }\n}\n"}, "11");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0]);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(1); }\n\tpublic static void count(int[] array, int[] ... values) { System.out.print(2); }\n}\n"}, "1");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0]);\n\t\tY.count(new int[0], null);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(0); }\n\tpublic static void count(int[] array, int[][] ... values) { System.out.print(1); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0]);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.count(new int[0], null);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0], 1);\n\t\tY.count(new int[0], 1, 1);\n\t\tY.count(new int[0], 1, 1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) {}\n\tpublic static void count(int[] array, int[] ... values) {}\n\tpublic static void count(int[] array, int i, int ... values) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0], 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.count(new int[0], 1, 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n3. ERROR in X.java (at line 5)\n\tY.count(new int[0], 1, 1, 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tList l = Arrays.asList(x);\n\t\tSystem.out.println(l.size() + \" \" + l.get(0).getClass().getName());\n\t}\n}\n"}, "2 [Ljava.lang.String;");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tSystem.out.println(asList(x[0], x[1]).get(1).getClass().getName());\n\t}\n\tstatic <U> List<U> asList(U u1, U... us) {\n\t\tList<U> result = new ArrayList<U>();\n\t\tresult.add(u1);\n\t\tresult.add(us[0]);\n\t\treturn result;\n\t}\n}\n"}, "java.lang.String");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tSystem.out.println(asList(x[0], x).get(1).getClass().getName());\n\t}\n\tstatic <U> List<U> asList(U u1, U... us) {\n\t\tList<U> result = new ArrayList<U>();\n\t\tresult.add(u1);\n\t\tresult.add(us[0]);\n\t\treturn result;\n\t}\n}\n"}, "[Ljava.lang.String;");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\n\npublic class X {\n   public static void main(String[] args) {\n      String[][] arr = new String[][] { args };\n      ArrayList<String[]> al = new ArrayList<String[]>(Arrays.asList(arr));\n   }\n}\n"}, "");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString[] args;\n\tpublic X(String... args) {\n\t\tthis.args = args;\n\t}\n\tpublic static X foo() {\n\t\treturn new X(\"SU\", \"C\", \"CE\", \"SS\"){};\n\t}\n\tpublic String bar() {\n\t\tif (this.args != null) {\n\t\t\tStringBuffer buffer = new StringBuffer();\n\t\t\tfor (String s : this.args) {\n\t\t\t\tbuffer.append(s);\n\t\t\t}\n\t\t\treturn String.valueOf(buffer);\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo().bar());\n\t}\n}\n"}, "SUCCESS");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main (String[] args) {\n        new X().test (new byte[5]);\n\t\t System.out.print(\"SUCCESS\");\n    }\n    private void test (Object... params) {\n    }\n}"}, "SUCCESS");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic boolean foo(Object... args) {\n\t\treturn args == null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(null, null));\n\t}\n}"}, "false");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic boolean foo(Object... args) {\n\t\treturn args == null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(null));\n\t}\n}"}, "true");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tstatic void foo(int[] intarray) {\n\t\tList<int[]> l = Arrays.asList(intarray);\n\t\tSystem.out.print(l.get(0).length);\n\t}\n\tstatic void foo(String[] strarray) {\n\t\tList l = Arrays.asList(strarray);\n\t\tSystem.out.print(l);\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tfoo(new int[]{0, 1});\n\t\tfoo(new String[]{\"a\",\"b\"});\n\t\tSystem.out.println(\"done\");\n\t}\n}\n"}, "2[a, b]done");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\ttransient private X() {}\n\tvoid test() { X x = new X(); }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\ttransient private X() {}\r\n\t                  ^^^\nIllegal modifier for the method X.X()\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\ttransient private X(Object... o) {}\n\tvoid test() { X x = new X(1, 2); }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\ttransient private X(Object... o) {}\n\t                  ^^^^^^^^^^^^^^\nIllegal modifier for the method X.X()\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Method;\n\npublic class X {\n\tvoid test(Method method){ \n\t\ttry {\n\t\t\tmethod.invoke(this);\n\t\t\tmethod.invoke(this, new Class[0]);\n\t\t\tmethod.invoke(this, (Object[])new Class[0]);\n\t\t} catch (Exception e) {\n\t\t}\t\t\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tmethod.invoke(this, new Class[0]);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type Class[] should explicitly be cast to Object[] for the invocation of the varargs method invoke(Object, Object...) from type Method. It could alternatively be cast to Object for a varargs invocation\n----------\n2. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * Whatever you do, eclipse doesn't like it.\n */\npublic class X {\n\n\t/**\n\t * Passing a String vararg to a method needing an Object array makes eclipse\n\t * either ask for a cast or complain that it is unnecessary. You cannot do\n\t * it right.\n\t * \n\t * @param s\n\t */\n\tpublic static void q(String... s) {\n\t\t // OK reports: Varargs argument String[] should be cast to Object[] when passed to the method \tprintf(String, Object...) from type PrintStream\n\t\tSystem.out.printf(\"\", s);\n\t\t// WRONG reports: Unnecessary cast from String[] to Object[]\n\t\tSystem.out.printf(\"\", (Object[]) s); \n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 15)\n\tSystem.out.printf(\"\", s);\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type String[] should explicitly be cast to Object[] for the invocation of the varargs method printf(String, Object...) from type PrintStream. It could alternatively be cast to Object for a varargs invocation\n----------\n2. ERROR in X.java (at line 19)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", \"X\", new Integer(0));\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", \"X\", \"Y\");\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", new Float(0), new java.awt.Point(0, 0));\n\t}\n\tpublic static <A extends Serializable> void audit(String login,\n\t\t\tString address, String event, A... args) {\n\t\tfor (A a : args) {\n\t\t\tSystem.out.println(a.getClass());\n\t\t}\n\t}\n}"}, "class java.lang.String\nclass java.lang.Integer\nclass java.lang.String\nclass java.lang.String\nclass java.lang.Float\nclass java.awt.Point");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Tester();\n\t\tt.method(\"SUCCESS\");\n\t}\n\n\tstatic abstract class Test<A> {\n\t\tabstract void method(A... args);\n\t}\n\n\tstatic class Tester extends Test<String> {\n\n\t\t@Override void method(String... args) {\n\t\t\tcall(args);\n\t\t}\n\n\t\tvoid call(String[] args) {\n\t\t\tfor (String str : args)\n\t\t\t\tSystem.out.println(str);\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test032() {
        this.runConformTest(new String[]{"Functor.java", "public class Functor<T> {\n\tpublic void func(T... args) {\n\t\t// do noting;\n\t}\n\t\n\tpublic static void main(String... args) {\n\t\tFunctor<String> functor = new Functor<String>() {\n\t\t\tpublic void func(String... args) {\n\t\t\t\tSystem.out.println(args.length);\n\t\t\t}\n\t\t};\n\t\tfunctor.func(\"Hello!\");\n\t}\n}\n"}, "1");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid a(boolean b, Object... o) {System.out.print(1);}\n\tvoid a(Object... o) {System.out.print(2);}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.a(true);\n\t\tx.a(true, \"foobar\");\n\t\tx.a(\"foo\", \"bar\");\n\t}\n}\n"}, "112");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid b(boolean b, Object... o) {}\n\tvoid b(Boolean... o) {}\n\tvoid c(boolean b, boolean b2, Object... o) {}\n\tvoid c(Boolean b, Object... o) {}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.b(true);\n\t\tx.b(true, false);\n\t\tx.c(true, true, true);\n\t\tx.c(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\r\n\tx.b(true);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 9)\r\n\tx.b(true, false);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 10)\r\n\tx.c(true, true, true);\r\n\t  ^\nThe method c(boolean, boolean, Object[]) is ambiguous for the type X\n----------\n4. ERROR in X.java (at line 11)\r\n\tx.c(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);\r\n\t  ^\nThe method c(boolean, boolean, Object[]) is ambiguous for the type X\n----------\n");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "import java.util.*; \n\npublic class X {\n  public static void main(String[] args) {\n    double[][] d = { { 1 } , { 2 } }; \n    List<double[]> l = Arrays.asList(d); // <T> List<T> asList(T... a)\n    System.out.println(\"List size: \" + l.size());\n  }\n}\n"}, "List size: 2");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static <T> void foo(T ... values) {\n      System.out.print(values.getClass());\n  }\n\tpublic static void main(String args[]) {\n\t   X.<String>foo(\"monkey\", \"cat\");\n      X.<String>foo(new String[] { \"monkey\", \"cat\" });\n\t}\n}"}, "class [Ljava.lang.String;class [Ljava.lang.String;");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public void testBreak() {\n        Collection<Class> classes = new ArrayList<Class>();\n        classes.containsAll(Arrays.asList(String.class, Integer.class, Long.class));\n    }\n}\n"}, "");
    }

    public void test037() {
        this.runConformTest(new String[]{"V.java", "public class V {\n    public static void main(String[] s) {\n        V v = new V();\n        v.foo(\"\", v, null, \"\");\n        v.foo(\"\", v, null, \"\", 1);\n        v.foo2(\"\");\n        v.foo2(\"\", null);\n        v.foo2(\"\", null, null);\n        v.foo3(\"\", v, null, \"\", null);\n    }\n    void foo(String s, V v, Object... obs) {System.out.print(1);}\n    void foo(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n    void foo2(Object... a) {System.out.print(1);}\n    void foo2(String s, Object... a) {System.out.print(2);}\n    void foo2(String s, Object o, Object... a) {System.out.print(3);}\n    void foo3(String s, V v, String... obs) {System.out.print(1);}\n    void foo3(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n}\n"}, "222232");
        this.runNegativeTest(new String[]{"V.java", "public class V {\n    public static void main(String[] s) {\n        V v = new V();\n        v.foo2(null, \"\");\n        v.foo2(null, \"\", \"\");\n        v.foo3(\"\", v, null, \"\");\n    }\n    void foo2(String s, Object... a) {System.out.print(2);}\n    void foo2(String s, Object o, Object... a) {System.out.print(3);}\n    void foo3(String s, V v, String... obs) {System.out.print(1);}\n    void foo3(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n}\n"}, "----------\n1. ERROR in V.java (at line 4)\r\n\tv.foo2(null, \"\");\r\n\t  ^^^^\nThe method foo2(String, Object[]) is ambiguous for the type V\n----------\n2. ERROR in V.java (at line 5)\r\n\tv.foo2(null, \"\", \"\");\r\n\t  ^^^^\nThe method foo2(String, Object[]) is ambiguous for the type V\n----------\n3. ERROR in V.java (at line 6)\r\n\tv.foo3(\"\", v, null, \"\");\r\n\t  ^^^^\nThe method foo3(String, V, String[]) is ambiguous for the type V\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.println(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n\t     varargs(new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t     //should be cast to Serializable[] ..\", but proposed cast to\n\t     //Serializable[] fails at runtime (javac does not warn here)\n\t     varargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t     //should be cast to Serializable[] ..\", but proposed cast to\n\t     //Serializable[] fails at runtime (javac does not warn here)\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 13)\n\tvarargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable[]\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n    \ttry {\n\t        varargs(new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t        \t//should be cast to Serializable[] ..\", but proposed cast to\n\t            //Serializable[] fails at runtime (javac does not warn here)\n\t        varargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t    \t//should be cast to Serializable[] ..\", but proposed cast to\n\t        //Serializable[] fails at runtime (javac does not warn here)\n    \t} catch(ClassCastException e) {\n    \t\tSystem.out.println(\"SUCCESS\");\n    \t}\n    }\n}\n"}, "[[1, 2]] (argument wrapped)SUCCESS");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array(new Serializable[] {3, 4});\n        array(new Integer[] {5, 6}); //warns (as javac does)\n        array(null); //warns (as javac does)\n    }\n}\n"}, "[3, 4][5, 6]null");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array(new Serializable[] {3, 4});\n        array(new Integer[] {5, 6}); //warns (as javac does)\n        array(null); //warns (as javac does)\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tarray(new Integer[] {5, 6}); //warns (as javac does)\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe argument of type Integer[] should explicitly be cast to Serializable[] for the invocation of the varargs method array(Serializable...) from type X. It could alternatively be cast to Serializable for a varargs invocation\n----------\n2. WARNING in X.java (at line 12)\n\tarray(null); //warns (as javac does)\n\t^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Serializable[] for the invocation of the varargs method array(Serializable...) from type X. It could alternatively be cast to Serializable for a varargs invocation\n----------\n3. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        varargs((Serializable) new Object[] {1, 2});\n        varargs((Serializable) new Serializable[] {3, 4}); //warns about\n            //unnecessary cast, although cast is necessary (causes varargs call)\n        varargs((Serializable) new Integer[] {5, 6});\n        varargs((Serializable) null);\n    }\n}\n"}, "[[1, 2]] (argument wrapped)[[3, 4]] (argument wrapped)[[5, 6]] (argument wrapped)[null] (argument wrapped)");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        varargs((Serializable) new Object[] {1, 2});\n        varargs((Serializable) new Serializable[] {3, 4}); //warns about\n            //unnecessary cast, although cast is necessary (causes varargs call)\n        varargs((Serializable) new Integer[] {5, 6});\n        varargs((Serializable) null);\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvarargs((Serializable) new Object[] {1, 2});\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable\n----------\n2. ERROR in X.java (at line 15)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n        array((Serializable[]) new Integer[] {5, 6});\n        array((Serializable[]) null);\n        try {\n\t        array((Serializable[]) new Object[] {1, 2}); // CCE at run time\n        } catch(ClassCastException e) {\n        \tSystem.out.println(\"SUCCESS\");\n        }\n    }\n}\n"}, "[3, 4][5, 6]nullSUCCESS");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n        array((Serializable[]) new Integer[] {5, 6});\n        array((Serializable[]) null);\n\t     array((Serializable[]) new Object[] {1, 2}); // CCE at run time\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tarray((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Serializable[] to Serializable[]\n----------\n2. WARNING in X.java (at line 13)\n\tarray((Serializable[]) new Object[] {1, 2}); // CCE at run time\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable[]\n----------\n3. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Throwable... exceptions) {\n\t}\n\tvoid bar(Exception[] exceptions) {\n\t\tfoo((Throwable[])exceptions);\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tfoo((Throwable[])exceptions);\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Exception[] to Throwable[]\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object id, Object value, String... groups) {}\n\tvoid foo(Y y, String... groups) {System.out.println(true);}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(new Y(), \"a\", \"b\");\n\t}\n}\nclass Y {}"}, "true");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y, Object value, String... groups) {}\n\tvoid foo(Object id, String... groups) {}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(new Y(), \"a\", \"b\");\n\t}\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 5)\r\n\tnew X().foo(new Y(), \"a\", \"b\");\r\n\t        ^^^\nThe method foo(Y, Object, String[]) is ambiguous for the type X\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        Y<String> [] foo() {\n                return null;\n        }\n        void bar(Y... y) {\n        }\n        void fred() {\n                bar(foo());\n                bar((Y[])foo());\n                Zork z;\n        }\n}\nclass Y<E> {\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid bar(Y... y) {\n\t         ^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tbar((Y[])foo());\n\t    ^^^^^^^^^^\nUnnecessary cast from Y<String>[] to Y[]\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        this.runConformTest(new String[]{"Y.java", "public class Y extends X {\n\tpublic static void main(String[] args) {\n\t\tY y = new Y();\n\t\ty.a(null, \"\");\n\t\ty.a(null);\n\t\ty.a(y, \"\");\n\t\ty.a(y);\n\t\ty.a(y, \"\", y, y);\n\t\ty.a(y, y, y);\n\t}\n\t@Override public void a(Object anObject, String aString, Object... args) { super.a(anObject, aString, this, args); }\n\t@Override public void a(Object anObject, Object... args) { super.a(anObject, this, args); }\n}\nclass X implements I {\n\tpublic void a(Object anObject, String aString, Object... args) { System.out.print(1); }\n\tpublic void a(Object anObject, Object... args) { System.out.print(2); }\n}\ninterface I {\n\tvoid a(Object anObject, String aString, Object... args);\n\tvoid a(Object anObject, Object... args);\n}\n"}, "121212");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.Arrays;\n public class X {\n   public static void main( String args[] ) {\n      Object test = new Object[] { \"Hello\", \"World\" };\n      System.out.println(Arrays.asList(test));\n      System.out.println(Arrays.asList((Object[])test)); // Warning here\n\t   Zork z;\n   }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", " import java.util.Arrays;\n public class X {\n   public static void main( String args[] ) {\n      Object test = new Object[] { \"Hello\", \"World\" };\n      System.out.print(Arrays.asList(test).size());\n      System.out.println(Arrays.asList((Object[])test).size()); // Warning here\n   }\n}"}, "12");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid addChildren(Widget w) {\n\t\tif (w instanceof Composite) {\n\t\t\tComposite composite = (Composite) w;\n\t\t\taddAll((Widget[]) composite.getChildren());\n\t\t\taddAll(composite.getChildren());\n\t\t}\n\t\tZork z;\n\t}\n\tvoid addAll(Widget... widgets) {\n\t}\n}\n\nclass Widget {}\nclass Control extends Widget {}\nclass Composite extends Control {\n\tControl[] getChildren() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\taddAll((Widget[]) composite.getChildren());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Control[] to Widget[]\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid addChildren(Widget w) {\n\t\tif (w instanceof Composite) {\n\t\t\tComposite composite = (Composite) w;\n\t\t\taddAll((Control[]) composite.getChildren());\n\t\t\taddAll(composite.getChildren());\n\t\t}\n\t\tZork z;\n\t}\n\tvoid addAll(Control... widgets) {\n\t}\n}\n\nclass Widget {}\nclass Control extends Widget {}\nclass Composite extends Control {\n\tControl[] getChildren() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\taddAll((Control[]) composite.getChildren());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Control[] to Control[]\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork z;\n\tpublic static void varargs(Object... args) {\n\t\tif (args == null) {\n\t\t\tSystem.out.println(\"args is null\");\n\t\t\treturn;\n\t\t}\n\t\tif (args.length == 0) {\n\t\t\tSystem.out.println(\"args is of length 0\");\n\t\t\treturn;\n\t\t}\n\n\t\tSystem.out.println(args.length + \" \" + args[0]);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"boxing\")\n\t\tInteger[] i = { 0, 1, 2, 3, 4 };\n\t\tvarargs(i);\n\t\tvarargs((Object[]) i);\n\t\tvarargs((Object) i);\n\t\tvarargs(i.clone());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 19)\n\tvarargs(i);\n\t^^^^^^^^^^\nThe argument of type Integer[] should explicitly be cast to Object[] for the invocation of the varargs method varargs(Object...) from type X. It could alternatively be cast to Object for a varargs invocation\n----------\n3. WARNING in X.java (at line 22)\n\tvarargs(i.clone());\n\t^^^^^^^^^^^^^^^^^^\nThe argument of type Integer[] should explicitly be cast to Object[] for the invocation of the varargs method varargs(Object...) from type X. It could alternatively be cast to Object for a varargs invocation\n----------\n");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate static int elementCount(Object... elements) {\n     return elements == null ? 0 : elements.length;\n   }\n   public static void main(String... args) {\n     System.out.print(\"null length array: \" + elementCount(null));\n     System.out.print(\"/[null] length array: \" + elementCount((Object)null));\n     System.out.print(\"/empty length array: \" + elementCount());\n     System.out.println(\"/[a,b,c] length array: \" + elementCount(\"a\", \"b\", \"c\"));\n   }\n}"}, "null length array: 0/[null] length array: 1/empty length array: 0/[a,b,c] length array: 3");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork z;\n\tprivate static int elementCount(Object... elements) {\n     return elements == null ? 0 : elements.length;\n   }\n   public static void main(String... args) {\n     System.out.print(\"null length array: \" + elementCount(null));\n     System.out.print(\"/[null] length array: \" + elementCount((Object)null));\n     System.out.print(\"/empty length array: \" + elementCount());\n     System.out.println(\"/[a,b,c] length array: \" + elementCount(\"a\", \"b\", \"c\"));\n   }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 7)\n\tSystem.out.print(\"null length array: \" + elementCount(null));\n\t                                         ^^^^^^^^^^^^^^^^^^\nThe argument of type null should explicitly be cast to Object[] for the invocation of the varargs method elementCount(Object...) from type X. It could alternatively be cast to Object for a varargs invocation\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.RetentionPolicy;\n\npublic class X {\n\n  void a(Enum<?>...enums) {}\n\n  void b () {\n    RetentionPolicy[] t = null;\n    a(t);\n    a((Enum<?>[])t);\n    Zork z;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\ta((Enum<?>[])t);\n\t  ^^^^^^^^^^^^\nUnnecessary cast from RetentionPolicy[] to Enum<?>[]\n----------\n2. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void testPassingSubclassArrayAsVararg() {\n        // The argument of type VarargsTest.Subclass[] should explicitly be\n        // cast to VarargsTest.Parent[] for the invocation of the varargs\n        // method processVararg(VarargsTest.Parent...) from type VarargsTest.\n        // It could alternatively be cast to VarargsTest.Parent for a varargs\n        // invocation\n        processVararg(new Subclass[] {});\n    }\n\n    public void testPassingSubclassArrayAsVarargWithCast() {\n        // Unnecessary cast from VarargsTest.Subclass[] to\n        // VarargsTest.Parent[]\n        processVararg((Parent[]) new Subclass[] {});\n        processVararg(new Subclass[] {});\n        Zork z;\n    }\n\n    private void processVararg(Parent... objs) {\n    }\n\n    class Parent {\n    }\n\n    class Subclass extends Parent {\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 14)\n\tprocessVararg((Parent[]) new Subclass[] {});\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X.Subclass[] to X.Parent[]\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t\tInteger[] array = null;\n\t\tvarargs(array);\n\t}\n\n\tpublic void varargs(Number... o) {\n\t}\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }
}

