/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.JptJpaEclipseLinkCorePlugin;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.platform.EclipseLinkPlatform;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLink1_1JpaProjectTests
extends ContextModelTestCase {
    public EclipseLink1_1JpaProjectTests(String name) {
        super(name);
    }

    protected JpaPlatformDescription getJpaPlatformDescription() {
        return EclipseLinkPlatform.VERSION_1_1;
    }

    protected EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLink1_1ContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_1_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLinkContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetDefaultEclipseLinkOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_1OrmXmlFile();
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_1_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLinkContentType() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.lastSegment());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLink1_1ContentType() throws Exception {
        this.createEclipseLink1_1OrmXmlFile(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.lastSegment());
    }

    private void createDefaultEclipseLink1_1OrmXmlFile() throws Exception {
        this.createEclipseLink1_1OrmXmlFile(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH.lastSegment());
    }

    private void createEclipseLink1_1OrmXmlFile(String fileName) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)fileName);
        config.setProperty("JpaFileCreationDataModelProperties.VERSION", (Object)"1.1");
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_1OrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_1_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH);
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
    }

    public void testGetDifferentlyNamedMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_1OrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_1_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_1JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_1OrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_1JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_1JpaProjectTests.assertEquals((Object)JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_1_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_1JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

