/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_2ContextModelTestCase;

public class EclipseLink2_2JavaEntityTests
extends EclipseLink2_2ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public EclipseLink2_2JavaEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEclipseLinkEntity entity = (JavaEclipseLinkEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        entity.getConverterContainer().addCustomConverter(0);
        entity.getConverterContainer().addCustomConverter(1);
        entity.getConverterContainer().addObjectTypeConverter(0);
        entity.getConverterContainer().addObjectTypeConverter(1);
        entity.getConverterContainer().addTypeConverter(0);
        entity.getConverterContainer().addTypeConverter(1);
        entity.getConverterContainer().addStructConverter(0);
        entity.getConverterContainer().addStructConverter(1);
        this.getJavaPersistentType().setMappingKey("mappedSuperclass");
        EclipseLink2_2JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof MappedSuperclass));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Inheritance"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorValue"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorColumn"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedQuery"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedNativeQuery"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEclipseLinkEntity entity = (JavaEclipseLinkEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        entity.getConverterContainer().addCustomConverter(0);
        entity.getConverterContainer().addCustomConverter(1);
        entity.getConverterContainer().addObjectTypeConverter(0);
        entity.getConverterContainer().addObjectTypeConverter(1);
        entity.getConverterContainer().addTypeConverter(0);
        entity.getConverterContainer().addTypeConverter(1);
        entity.getConverterContainer().addStructConverter(0);
        entity.getConverterContainer().addStructConverter(1);
        this.getJavaPersistentType().setMappingKey("embeddable");
        EclipseLink2_2JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Inheritance"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorValue"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorColumn"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        EclipseLink2_2JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedQuery"));
        EclipseLink2_2JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedNativeQuery"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
    }
}

