/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaConvertTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkJavaConvertTests(String name) {
        super(name);
    }

    public void testGetConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getConverterName());
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getDefaultConverterName());
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
    }

    public void testGetConvertName2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"class-instance", (String)eclipseLinkConvert.getConverterName());
    }

    public void testSetSpecifiedConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        basicMapping.setConverter(EclipseLinkConvert.class);
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
        eclipseLinkConvert.setSpecifiedConverterName("foo");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConvertAnnotation convertAnnotation = (EclipseLinkConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)convertAnnotation.getValue());
        eclipseLinkConvert.setSpecifiedConverterName(null);
        convertAnnotation = (EclipseLinkConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertNotNull((Object)convertAnnotation);
        EclipseLinkJavaConvertTests.assertEquals(null, (String)convertAnnotation.getValue());
    }

    public void testGetConverterNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaConvertTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConvertTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConvertTests.assertNull((Object)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaConvertTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }
}

