/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @Converter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @Converter(converterClass=Foo.class");
            }
        });
    }

    public EclipseLinkJavaConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConverterAnnotation converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConverterAnnotation converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        converterAnnotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getCustomConverters().iterator().hasNext());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"FOO", (String)converter.getName());
    }

    public void testGetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConverterAnnotation converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverterClass());
        converter.setConverterClass(null);
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converterAnnotation.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverterClass());
    }

    public void testGetConverterClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkCustomConverter converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConverterAnnotation converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        converterAnnotation.setConverterClass("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getCustomConverters().iterator().hasNext());
        converterAnnotation = (EclipseLinkConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setConverterClass("FooBar");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkCustomConverter)basicMapping.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLinkJavaConverterTests.assertEquals((String)"FooBar", (String)converter.getConverterClass());
    }
}

