/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyRelationship;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaOneToManyMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithPrivateOwnedOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("implements java.io.Serializable");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private java.util.Collection<AnnotationTestType> myTypes;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToManyMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        resourceField.addAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationship rel = mapping.getRelationship();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationship rel = mapping.getRelationship();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testDefaultOneToMany() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToManySetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)specifiedOneToManyMapping.getFetch());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)annotation.getFetch());
    }

    public void testDefaultOneToManySetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getSpecifiedTargetEntity());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getTargetEntity());
    }

    public void testDefaultOneToManySetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getMappedBy());
    }

    public void testDefaultOneToManySetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setAll(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isAll());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeAll());
    }

    public void testDefaultOneToManySetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setMerge(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isMerge());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeMerge());
    }

    public void testDefaultOneToManySetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setPersist(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isPersist());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadePersist());
    }

    public void testDefaultOneToManySetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRefresh(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRefresh());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRefresh());
    }

    public void testDefaultOneToManySetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRemove(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRemove());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRemove());
    }
}

