/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlOneToMany_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmOneToManyRelationship2_0;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0OrmOneToManyMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0OrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithValidOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestTypeWithCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"java.util.Collection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    private Collection<Foo> oneToMany;").append(CR);
            }
        });
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToManyMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)oneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)oneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)virtualOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isNoMapKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)virtualOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)virtualOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)virtualOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.isNoMapKey());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
        oneToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getMapKeyClass());
        oneToMany.getMapKeyClass().setClassName("String");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName("String");
        oneToMany.setMapKeyClass(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping2_0 virtualOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualOneToManyMapping.getDefaultMapKeyClass());
        javaOneToManyMapping.setSpecifiedMapKeyClass("Integer");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Integer", (String)virtualOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Integer", (String)virtualOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualOneToManyMapping.getDefaultMapKeyClass());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualOneToManyMapping = (OneToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)virtualOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualOneToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
        ormOneToManyMapping.setSpecifiedMapKeyClass("String");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        ormOneToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("jobs"), "oneToMany");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("queue");
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        OrmPersistentType printJobPersistentType = (OrmPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTable());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("jobs"), "oneToMany");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.removeFromXml();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("jobs");
        OneToManyMapping virtualOneToManyMapping = (OneToManyMapping)ormPersistentAttribute2.getMapping();
        orderable = (Orderable2_0)virtualOneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping2_0 addressesVirtualMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormColumn.isUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getScale());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping2_0 addressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)addressesPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormColumn.isNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormColumn.isUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getScale());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        OrmOneToManyMapping2_0 addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        OneToManyMapping2_0 addressesVirtualMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getTable());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormColumn.getTable());
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("JAVA_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getTable());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "oneToMany");
        OrmOneToManyMapping2_0 addressesMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getDefaultTable());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmEclipseLinkOneToManyMapping contextMapping = (OrmEclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOrmOneToManyRelationship2_0 rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmEclipseLinkOneToManyMapping contextMapping = (OrmEclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOrmOneToManyRelationship2_0 rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 virtualOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        ((OneToManyRelationship2_0)javaOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        JoinColumn joinColumn = (JoinColumn)((OneToManyRelationship2_0)virtualOneToManyMapping.getRelationship()).getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)joinColumn.getDefaultTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).strategyIsJoinColumn());
        ((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        joinColumn = (JoinColumn)((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        joinColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 virtualOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        ((OneToManyRelationship2_0)javaOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)virtualOneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getMapKeyColumn().getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)virtualOneToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"foo", (String)virtualOneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"foo", (String)virtualOneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)virtualOneToManyMapping.getMapKeyColumn().getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)virtualOneToManyMapping.getMapKeyColumn().getDefaultTable());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).strategyIsJoinColumn());
        ((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormOneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)ormOneToManyMapping.getMapKeyColumn().getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormOneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)ormOneToManyMapping.getMapKeyColumn().getTable());
        ormOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormOneToManyMapping.getMapKeyColumn().getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)ormOneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)ormOneToManyMapping.getMapKeyColumn().getDefaultTable());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 virtualOneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getMapping();
        ((OneToManyRelationship2_0)javaOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = ((Orderable2_0)virtualOneToManyMapping.getOrderable()).getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)orderColumn.getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        persistentAttribute.addToXml();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).strategyIsJoinColumn());
        ((OneToManyRelationship2_0)ormOneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((Orderable2_0)ormOneToManyMapping.getOrderable()).isOrderColumnOrdering());
        ((Orderable2_0)ormOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        orderColumn = ((Orderable2_0)ormOneToManyMapping.getOrderable()).getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOneToManyMapping virtualOneToManyMapping = (EclipseLinkOneToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualOneToManyMapping.getSpecifiedFetch());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getSpecifiedTargetEntity());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)virtualOneToManyMapping.getCascade();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isCustomOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)((OrphanRemovalHolder2_0)virtualOneToManyMapping).getOrphanRemoval().isOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)virtualOneToManyMapping.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLinkOneToManyMapping virtualOneToManyMapping = (EclipseLinkOneToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualOneToManyMapping.getFetch());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"test.Address", (String)virtualOneToManyMapping.getTargetEntity());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)virtualOneToManyMapping.getCascade();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isNoOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)virtualOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((OrphanRemovalHolder2_0)virtualOneToManyMapping).getOrphanRemoval().isOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)virtualOneToManyMapping.getJoinFetch().getValue());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)oneToManyResource.getMapKeyEnumerated());
        oneToManyResource.setMapKeyEnumerated(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        ormOneToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.ORDINAL);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)oneToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)oneToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormOneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ormOneToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
    }

    public void testUpdateSpecifiedTemporal() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.DATE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)TemporalType.DATE, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.TIME);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(TemporalType.TIMESTAMP);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)oneToManyResource.getMapKeyTemporal());
        oneToManyResource.setMapKeyTemporal(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
    }

    public void testModifySpecifiedTemporal() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany_2_0 oneToManyResource = (XmlOneToMany_2_0)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        ormOneToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)TemporalType.DATE, (Object)oneToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        ((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)oneToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormOneToManyMapping.getMapKeyConverter()).getTemporalType());
        ormOneToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKeyConverter().getType());
    }
}

