/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Options;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.TargetDatabase;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.TargetServer;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class OptionsAdapterTests
extends EclipseLinkPersistenceUnitTestCase {
    private Options options;
    private static final String SESSION_NAME_KEY = "eclipselink.session-name";
    private static final String SESSION_NAME_TEST_VALUE = "session-name.test";
    private static final String SESSION_NAME_TEST_VALUE_2 = "session-name-2.test";
    private static final String SESSIONS_XML_KEY = "eclipselink.sessions-xml";
    private static final String SESSIONS_XML_TEST_VALUE = "sessions-xml.test";
    private static final String SESSIONS_XML_TEST_VALUE_2 = "sessions-xml-2.test";
    public static final String TARGET_DATABASE_KEY = "eclipselink.target-database";
    public static final TargetDatabase TARGET_DATABASE_TEST_VALUE = TargetDatabase.cloudscape;
    public static final String TARGET_DATABASE_TEST_VALUE_2 = "custom.targetDatabase.test";
    private static final String TARGET_SERVER_KEY = "eclipselink.target-server";
    private static final TargetServer TARGET_SERVER_TEST_VALUE = TargetServer.weblogic_9;
    private static final String TARGET_SERVER_TEST_VALUE_2 = "custom.targetServer.test";
    public static final String INCLUDE_DESCRIPTOR_QUERIES_KEY = "eclipselink.session.include.descriptor.queries";
    public static final Boolean INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE = false;
    public static final Boolean INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2 = INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE == false;
    public static final String SESSION_EVENT_LISTENER_KEY = "eclipselink.session-event-listener";
    public static final String SESSION_EVENT_LISTENER_TEST_VALUE = "acme.CustomSessionEventListener";
    public static final String SESSION_EVENT_LISTENER_TEST_VALUE_2 = "oracle.sessions.CustomSessionEventListener";
    public static final String TEMPORAL_MUTABLE_KEY = "eclipselink.temporal.mutable";
    public static final Boolean TEMPORAL_MUTABLE_TEST_VALUE = true;
    public static final Boolean TEMPORAL_MUTABLE_TEST_VALUE_2 = TEMPORAL_MUTABLE_TEST_VALUE == false;

    public OptionsAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.options = this.subject.getOptions();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.options.addPropertyChangeListener("sessionName", propertyChangeListener);
        this.options.addPropertyChangeListener("sessionsXml", propertyChangeListener);
        this.options.addPropertyChangeListener("targetDatabase", propertyChangeListener);
        this.options.addPropertyChangeListener("targetServer", propertyChangeListener);
        this.options.addPropertyChangeListener("eventListener", propertyChangeListener);
        this.options.addPropertyChangeListener("includeDescriptorQueriesy", propertyChangeListener);
        this.options.addPropertyChangeListener("temporalMutable", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 7;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE);
        this.persistenceUnitSetProperty(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.1", "value.1");
        this.persistenceUnitSetProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE.toString());
        this.persistenceUnitSetProperty("misc.property.2", "value.2");
        this.persistenceUnitSetProperty("misc.property.3", "value.3");
        this.persistenceUnitSetProperty(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE);
        this.persistenceUnitSetProperty(TARGET_SERVER_KEY, TARGET_SERVER_TEST_VALUE);
        this.persistenceUnitSetProperty(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.4", "value.4");
        this.persistenceUnitSetProperty(TEMPORAL_MUTABLE_KEY, TEMPORAL_MUTABLE_TEST_VALUE.toString());
    }

    public void testSetSessionName() throws Exception {
        this.verifyModelInitialized(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE);
        this.verifySetProperty(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE, SESSION_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveSessionName() throws Exception {
        this.verifyAddRemoveProperty(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE, SESSION_NAME_TEST_VALUE_2);
    }

    public void testSetSessionsXml() throws Exception {
        this.verifyModelInitialized(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE);
        this.verifySetProperty(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE, SESSIONS_XML_TEST_VALUE_2);
    }

    public void testAddRemoveSessionsXml() throws Exception {
        this.verifyAddRemoveProperty(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE, SESSIONS_XML_TEST_VALUE_2);
    }

    public void testSetIncludeDescriptorQueries() throws Exception {
        this.verifyModelInitialized(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE);
        this.verifySetProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2);
    }

    public void testAddRemoveIncludeDescriptorQueries() throws Exception {
        this.verifyAddRemoveProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2);
    }

    public void testSetTargetDatabase() throws Exception {
        this.verifyModelInitialized(TARGET_DATABASE_KEY, this.getPropertyStringValueOf(TARGET_DATABASE_TEST_VALUE));
        this.verifySetProperty(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE, TARGET_DATABASE_TEST_VALUE_2);
        this.verifySetTargetDatabase(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE, TARGET_DATABASE_TEST_VALUE_2);
    }

    public void testAddRemoveTargetDatabase() throws Exception {
        this.verifyAddRemoveProperty(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE, TARGET_DATABASE_TEST_VALUE_2);
    }

    protected void verifySetTargetDatabase(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.options.setTargetDatabase(null);
        OptionsAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        OptionsAdapterTests.assertNotNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, this.getPropertyStringValueOf(testValue1));
        this.clearEvent();
        this.options.setTargetDatabase(null);
        OptionsAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    public void testSetTargetServer() throws Exception {
        this.verifyModelInitialized(TARGET_SERVER_KEY, this.getPropertyStringValueOf(TARGET_SERVER_TEST_VALUE));
        this.verifySetProperty(TARGET_SERVER_KEY, TARGET_SERVER_TEST_VALUE, TARGET_SERVER_TEST_VALUE_2);
        this.verifySetTargetServer(TARGET_SERVER_KEY, TARGET_SERVER_TEST_VALUE, TARGET_SERVER_TEST_VALUE_2);
    }

    public void testAddRemoveTargetServer() throws Exception {
        this.verifyAddRemoveProperty(TARGET_SERVER_KEY, TARGET_SERVER_TEST_VALUE, TARGET_SERVER_TEST_VALUE_2);
    }

    protected void verifySetTargetServer(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.options.setTargetServer(null);
        OptionsAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        OptionsAdapterTests.assertNotNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, this.getPropertyStringValueOf(testValue1));
        this.clearEvent();
        this.options.setTargetServer(null);
        OptionsAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    public void testSetEventListener() throws Exception {
        this.verifyModelInitialized(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE);
        this.verifySetProperty(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE, SESSION_EVENT_LISTENER_TEST_VALUE_2);
    }

    public void testAddRemoveEventListener() throws Exception {
        this.verifyAddRemoveProperty(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE, SESSION_EVENT_LISTENER_TEST_VALUE_2);
    }

    public void testSetTemporalMutable() throws Exception {
        this.verifyModelInitialized(TEMPORAL_MUTABLE_KEY, TEMPORAL_MUTABLE_TEST_VALUE);
        this.verifySetProperty(TEMPORAL_MUTABLE_KEY, TEMPORAL_MUTABLE_TEST_VALUE, TEMPORAL_MUTABLE_TEST_VALUE_2);
    }

    public void testAddRemoveTemporalMutable() throws Exception {
        this.verifyAddRemoveProperty(TEMPORAL_MUTABLE_KEY, TEMPORAL_MUTABLE_TEST_VALUE, TEMPORAL_MUTABLE_TEST_VALUE_2);
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("sessionName")) {
            this.options.setSessionName((String)newValue);
        } else if (propertyName.equals("sessionsXml")) {
            this.options.setSessionsXml((String)newValue);
        } else if (propertyName.equals("includeDescriptorQueriesy")) {
            this.options.setIncludeDescriptorQueries((Boolean)newValue);
        } else if (propertyName.equals("targetDatabase")) {
            this.setTargetDatabaseProperty(newValue);
        } else if (propertyName.equals("targetServer")) {
            this.setTargetServerProperty(newValue);
        } else if (propertyName.equals("eventListener")) {
            this.options.setEventListener((String)newValue);
        } else if (propertyName.equals("temporalMutable")) {
            this.options.setTemporalMutable((Boolean)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    private void setTargetDatabaseProperty(Object newValue) {
        if (newValue.getClass().isEnum()) {
            this.options.setTargetDatabase((TargetDatabase)newValue);
        } else {
            this.options.setTargetDatabase((String)newValue);
        }
    }

    private void setTargetServerProperty(Object newValue) {
        if (newValue.getClass().isEnum()) {
            this.options.setTargetServer((TargetServer)newValue);
        } else {
            this.options.setTargetServer((String)newValue);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("sessionName")) {
            modelValue = this.options.getSessionName();
        } else if (propertyName.equals("sessionsXml")) {
            modelValue = this.options.getSessionsXml();
        } else if (propertyName.equals("includeDescriptorQueriesy")) {
            modelValue = this.options.getIncludeDescriptorQueries();
        } else if (propertyName.equals("targetDatabase")) {
            modelValue = this.options.getTargetDatabase();
        } else if (propertyName.equals("targetServer")) {
            modelValue = this.options.getTargetServer();
        } else if (propertyName.equals("eventListener")) {
            modelValue = this.options.getEventListener();
        } else if (propertyName.equals("temporalMutable")) {
            modelValue = this.options.getTemporalMutable();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        Object expectedValue_ = expectedValue;
        if (propertyName.equals("targetDatabase") || propertyName.equals("targetServer")) {
            expectedValue_ = this.convertToEclipseLinkStringValue(expectedValue);
        }
        super.verifyPutProperty(propertyName, expectedValue_);
    }

    private String convertToEclipseLinkStringValue(Object expectedValue) {
        return (String)(expectedValue != null && expectedValue.getClass().isEnum() ? this.getPropertyStringValueOf(expectedValue) : expectedValue);
    }

    protected PersistenceUnitProperties getModel() {
        return this.options;
    }
}

