/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.DdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.OutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.SchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerationValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private SchemaGeneration schemaGen;
    private PropertyValueModel<SchemaGeneration> schemaGenHolder;
    private ModifiablePropertyValueModel<DdlGenerationType> ddlGenerationTypeHolder;
    private PropertyChangeEvent ddlGenerationTypeEvent;
    private ModifiablePropertyValueModel<OutputMode> outputModeHolder;
    private PropertyChangeEvent outputModeEvent;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = DdlGenerationType.drop_and_create_tables;
    public static final OutputMode OUTPUT_MODE_TEST_VALUE = OutputMode.sql_script;

    public SchemaGenerationValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGen = this.subject.getSchemaGeneration();
        this.schemaGenHolder = new SimplePropertyValueModel((Object)this.schemaGen);
        this.ddlGenerationTypeHolder = this.buildDdlGenerationTypeAA(this.schemaGenHolder);
        PropertyChangeListener ddlGenerationTypeListener = this.buildDdlGenerationTypeChangeListener();
        this.ddlGenerationTypeHolder.addPropertyChangeListener("value", ddlGenerationTypeListener);
        this.ddlGenerationTypeEvent = null;
        this.outputModeHolder = this.buildOutputModeAA(this.schemaGenHolder);
        PropertyChangeListener outputModeListener = this.buildOutputModeChangeListener();
        this.outputModeHolder.addPropertyChangeListener("value", outputModeListener);
        this.outputModeEvent = null;
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.ddl-generation", DDL_GENERATION_TYPE_TEST_VALUE);
        this.persistenceUnitSetProperty("eclipselink.ddl-generation.output-mode", OUTPUT_MODE_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.schemaGen;
    }

    private ModifiablePropertyValueModel<DdlGenerationType> buildDdlGenerationTypeAA(PropertyValueModel<SchemaGeneration> subjectHolder) {
        return new PropertyAspectAdapter<SchemaGeneration, DdlGenerationType>(subjectHolder, new String[]{"ddlGenerationType"}){

            protected DdlGenerationType buildValue_() {
                return ((SchemaGeneration)this.subject).getDdlGenerationType();
            }

            protected void setValue_(DdlGenerationType enumValue) {
                ((SchemaGeneration)this.subject).setDdlGenerationType(enumValue);
            }
        };
    }

    private PropertyChangeListener buildDdlGenerationTypeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                SchemaGenerationValueModelTests.this.ddlGenerationTypeEvent = e;
            }
        };
    }

    private ModifiablePropertyValueModel<OutputMode> buildOutputModeAA(PropertyValueModel<SchemaGeneration> subjectHolder) {
        return new PropertyAspectAdapter<SchemaGeneration, OutputMode>(subjectHolder, new String[]{"outputMode"}){

            protected OutputMode buildValue_() {
                return ((SchemaGeneration)this.subject).getOutputMode();
            }

            protected void setValue_(OutputMode enumValue) {
                ((SchemaGeneration)this.subject).setOutputMode(enumValue);
            }
        };
    }

    private PropertyChangeListener buildOutputModeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                SchemaGenerationValueModelTests.this.outputModeEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyDdlGenerationTypeAAValue(DDL_GENERATION_TYPE_TEST_VALUE);
        SchemaGenerationValueModelTests.assertEquals((Object)SchemaGeneration.DEFAULT_SCHEMA_GENERATION_DDL_GENERATION_TYPE, (Object)this.schemaGen.getDefaultDdlGenerationType());
        this.verifyOutputModeAAValue(OUTPUT_MODE_TEST_VALUE);
        SchemaGenerationValueModelTests.assertEquals((Object)SchemaGeneration.DEFAULT_SCHEMA_GENERATION_OUTPUT_MODE, (Object)this.schemaGen.getDefaultOutputMode());
    }

    public void testSetValue() throws Exception {
        this.ddlGenerationTypeEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.ddlGenerationTypeHolder, "value");
        DdlGenerationType newDdlGenerationType = DdlGenerationType.create_tables;
        this.subject.setProperty("eclipselink.ddl-generation", this.getPropertyStringValueOf(newDdlGenerationType), false);
        this.verifyDdlGenerationTypeAAValue(newDdlGenerationType);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.ddlGenerationTypeEvent);
        this.outputModeEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.outputModeHolder, "value");
        OutputMode newOutputMode = OutputMode.database;
        this.outputModeHolder.setValue((Object)newOutputMode);
        this.verifyOutputModeAAValue(newOutputMode);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.outputModeEvent);
    }

    public void testSetNullValue() {
        this.ddlGenerationTypeEvent = null;
        this.subject.setProperty("eclipselink.ddl-generation", null, false);
        this.ddlGenerationTypeHolder.setValue(null);
        this.verifyDdlGenerationTypeAAValue(null);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.ddlGenerationTypeEvent);
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty("eclipselink.ddl-generation");
        SchemaGenerationValueModelTests.assertNull((Object)property);
        this.outputModeEvent = null;
        this.outputModeHolder.setValue(null);
        this.verifyOutputModeAAValue(null);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.outputModeEvent);
        property = this.getPersistenceUnit().getProperty("eclipselink.ddl-generation.output-mode");
        SchemaGenerationValueModelTests.assertNull((Object)property);
    }

    protected void verifyDdlGenerationTypeAAValue(DdlGenerationType testValue) {
        this.verifyAAValue((Enum)testValue, (Enum)this.schemaGen.getDdlGenerationType(), (PropertyValueModel)this.ddlGenerationTypeHolder, "eclipselink.ddl-generation");
    }

    protected void verifyOutputModeAAValue(OutputMode testValue) {
        this.verifyAAValue((Enum)testValue, (Enum)this.schemaGen.getOutputMode(), (PropertyValueModel)this.outputModeHolder, "eclipselink.ddl-generation.output-mode");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

