/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMultitenantAnnotation2_3;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MultitenantType2_3;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLink2_3JavaResourceModelTestCase;

public class EclipselinkMultitenantAnnotation2_3Tests
extends EclipseLink2_3JavaResourceModelTestCase {
    public EclipselinkMultitenantAnnotation2_3Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMultitenant() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Multitenant"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Multitenant");
            }
        });
    }

    private ICompilationUnit createTestMultitenantWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.MultitenantType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Multitenant(MultitenantType.SINGLE_TABLE)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithIncludeCriteria() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Multitenant"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Multitenant(includeCriteria=true)");
            }
        });
    }

    public void testMultitenant() throws Exception {
        ICompilationUnit cu = this.createTestMultitenant();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EclipseLinkMultitenantAnnotation2_3 multitenant = (EclipseLinkMultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipselinkMultitenantAnnotation2_3Tests.assertNotNull((Object)multitenant);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMultitenantWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EclipseLinkMultitenantAnnotation2_3 multitenant = (EclipseLinkMultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipselinkMultitenantAnnotation2_3Tests.assertEquals((Object)MultitenantType2_3.SINGLE_TABLE, (Object)multitenant.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMultitenantWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EclipseLinkMultitenantAnnotation2_3 multitenant = (EclipseLinkMultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipselinkMultitenantAnnotation2_3Tests.assertEquals((Object)MultitenantType2_3.SINGLE_TABLE, (Object)multitenant.getValue());
        multitenant.setValue(MultitenantType2_3.TABLE_PER_TENANT);
        EclipselinkMultitenantAnnotation2_3Tests.assertEquals((Object)MultitenantType2_3.TABLE_PER_TENANT, (Object)multitenant.getValue());
        this.assertSourceContains("@Multitenant(TABLE_PER_TENANT)", cu);
        multitenant.setValue(null);
        EclipselinkMultitenantAnnotation2_3Tests.assertNull((Object)multitenant.getValue());
        this.assertSourceDoesNotContain("(TABLE_PER_TENANT)", cu);
        this.assertSourceContains("@Multitenant", cu);
        this.assertSourceDoesNotContain("@Multitenant(", cu);
    }
}

