/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class JoinFetchTests
extends EclipseLinkJavaResourceModelTestCase {
    public JoinFetchTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinFetch");
            }
        });
    }

    private ICompilationUnit createTestJoinFetchWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinFetch(JoinFetchType.OUTER)");
            }
        });
    }

    public void testJoinFetch() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkJoinFetchAnnotation joinFetch = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertNotNull((Object)joinFetch);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetchWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkJoinFetchAnnotation joinFetch = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetch.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestJoinFetchWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkJoinFetchAnnotation joinFetch = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        JoinFetchTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetch.getValue());
        joinFetch.setValue(JoinFetchType.INNER);
        JoinFetchTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetch.getValue());
        this.assertSourceContains("@JoinFetch(INNER)", cu);
        joinFetch.setValue(null);
        JoinFetchTests.assertNull((Object)joinFetch.getValue());
        this.assertSourceDoesNotContain("(INNER)", cu);
        this.assertSourceContains("@JoinFetch", cu);
        this.assertSourceDoesNotContain("@JoinFetch(", cu);
    }
}

