/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class MutableAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public MutableAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMutable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Mutable");
            }
        });
    }

    private ICompilationUnit createTestMutableWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Mutable(value=true)");
            }
        });
    }

    public void testMutableAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestMutable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MutableAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable"));
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable"));
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
        mutableAnnotation.setValue(Boolean.FALSE);
        MutableAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        this.assertSourceContains("@Mutable(value=false)", cu);
        mutableAnnotation.setValue(null);
        mutableAnnotation.setValue(Boolean.FALSE);
        this.assertSourceContains("@Mutable(false)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
        mutableAnnotation.setValue(null);
        MutableAnnotationTests.assertNull((Object)mutableAnnotation.getValue());
        this.assertSourceContains("@Mutable", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

