/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test.newapi;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.XPath2Expression;
import org.eclipse.wst.xml.xpath2.processor.Engine;
import org.eclipse.wst.xml.xpath2.processor.util.DynamicContextBuilder;
import org.eclipse.wst.xml.xpath2.processor.util.StaticContextBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringPerformanceTest {
    private Document document;

    @Before
    public void setUp() throws Exception {
        this.document = this.buildBigDocument(6, -1, 5);
    }

    private Document buildBigDocument(int width, int deltaWidth, int depth) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document newDoc = dbf.newDocumentBuilder().newDocument();
        Element root = newDoc.createElementNS("urn:x-my-ns", "root");
        newDoc.appendChild(root);
        int created = this.fillElement(root, width, deltaWidth, 0, depth, newDoc);
        root.setAttribute("nodeCount", "" + created);
        return newDoc;
    }

    private int fillElement(Element parent, int width, int deltaWidth, int currentDepth, int depthMax, Document owner) {
        int nodesCreated = 3;
        parent.appendChild(owner.createComment("Width : " + width + ", deltaWidth: " + deltaWidth + " currentDepth: " + currentDepth));
        parent.appendChild(owner.createTextNode("\r\n"));
        Element child = owner.createElementNS("urn:x-my-ns", "element" + currentDepth);
        parent.appendChild(child);
        if (currentDepth < depthMax) {
            int i = 0;
            while (i < width) {
                child.setAttribute("childNumber", "" + (i + 1));
                nodesCreated += 1 + this.fillElement(child, width + deltaWidth, deltaWidth, currentDepth + 1, depthMax, owner);
                ++i;
            }
        } else {
            child.appendChild(owner.createTextNode("leaf"));
            ++nodesCreated;
        }
        return nodesCreated;
    }

    @After
    public void tearDown() throws Exception {
        this.document = null;
    }

    @Test
    public void countAllOperation1() throws ParserConfigurationException, XPathExpressionException {
        Document bigDoc = this.buildBigDocument(2, 1, 6);
        System.out.println(bigDoc.getDocumentElement().getAttribute("nodeCount"));
        String control = this.evalXPath1("count(//node())", bigDoc);
        String evaluated = this.evalXPath2("count(//node())", bigDoc, BigDecimal.class).toString();
        Assert.assertEquals((Object)control, (Object)evaluated);
    }

    @Test
    public void countAllOperationWithFilter() throws ParserConfigurationException, XPathExpressionException {
        Document bigDoc = this.buildBigDocument(2, 1, 5);
        System.out.println(bigDoc.getDocumentElement().getAttribute("nodeCount"));
        String control = this.evalXPath1("count(//node()[count(ancestor-or-self::*)>4])", bigDoc);
        String evaluated = this.evalXPath2("count(//node()[count(ancestor-or-self::*)>4])", bigDoc, BigDecimal.class).toString();
        Assert.assertEquals((Object)control, (Object)evaluated);
    }

    @Test
    public void countAllOperationBig() throws ParserConfigurationException, XPathExpressionException {
        Document bigDoc = this.buildBigDocument(2, 1, 7);
        System.out.println(bigDoc.getDocumentElement().getAttribute("nodeCount"));
        String control = this.evalXPath1("count(//node())", bigDoc);
        String evaluated = this.evalXPath2("count(//node())", bigDoc, BigDecimal.class).toString();
        Assert.assertEquals((Object)control, (Object)evaluated);
    }

    protected <R> R evalXPath2(String xpath, Node doc, Class<R> resultClass) {
        Object[] objectArray;
        StaticContextBuilder sc = new StaticContextBuilder();
        XPath2Expression path = new Engine().parseExpression(xpath, (StaticContext)sc);
        DynamicContextBuilder dynamicContext = new DynamicContextBuilder((StaticContext)sc);
        long before = System.nanoTime();
        if (doc != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = doc;
        } else {
            objectArray = new Object[]{};
        }
        ResultSequence rs = path.evaluate((DynamicContext)dynamicContext, objectArray);
        Assert.assertEquals((String)("Expected single result from '" + xpath + "'"), (long)1L, (long)rs.size());
        Object result = rs.value(0);
        long after = System.nanoTime();
        System.out.println("XPath2 " + xpath + " evaluated to " + result + " in " + (after - before) / 1000L + " \u00ce\u00bcs");
        Assert.assertTrue((String)("Exected XPath result instanceof class " + resultClass.getSimpleName() + " from '" + xpath + "', got " + result.getClass()), (boolean)resultClass.isInstance(result));
        return resultClass.cast(result);
    }

    protected String evalXPath1(String xpath, Node doc) throws XPathExpressionException {
        XPathExpression expression = XPathFactory.newInstance().newXPath().compile(xpath);
        long before = System.nanoTime();
        String result = expression.evaluate(doc);
        long after = System.nanoTime();
        System.out.println("XPath1 " + xpath + " evaluated to " + result + " in " + (after - before) / 1000L + " \u00ce\u00bcs");
        return result;
    }

    public static void elementToStream(Element element, Writer writer) {
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(writer);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception exception) {}
    }

    public static String documentToString(Document doc) {
        StringWriter sw = new StringWriter();
        FilteringPerformanceTest.elementToStream(doc.getDocumentElement(), sw);
        return sw.toString();
    }
}

