/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.SimpleBooleanReference;

public class SimpleBooleanReferenceTests
extends TestCase {
    public SimpleBooleanReferenceTests(String name) {
        super(name);
    }

    public void testGetValue() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testGetValueDefault() {
        SimpleBooleanReference br = new SimpleBooleanReference();
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testIs() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.is(true));
        SimpleBooleanReferenceTests.assertFalse((boolean)br.is(false));
    }

    public void testIsNot() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.isNot(true));
        SimpleBooleanReferenceTests.assertTrue((boolean)br.isNot(false));
    }

    public void testIsTrue() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.isTrue());
    }

    public void testIsFalse() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.isFalse());
        br.setFalse();
        SimpleBooleanReferenceTests.assertTrue((boolean)br.isFalse());
    }

    public void testSetValue() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setValue(false);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testFlip() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
        SimpleBooleanReferenceTests.assertFalse((boolean)br.flip());
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
        SimpleBooleanReferenceTests.assertTrue((boolean)br.flip());
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetNotBoolean() {
        SimpleBooleanReference br = new SimpleBooleanReference(false);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(false);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetTrue() {
        SimpleBooleanReference br = new SimpleBooleanReference(false);
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setTrue();
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetFalse() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setFalse();
        SimpleBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testClone() {
        SimpleBooleanReference br = new SimpleBooleanReference(true);
        SimpleBooleanReference clone = br.clone();
        SimpleBooleanReferenceTests.assertTrue((boolean)clone.getValue());
    }

    public void testToString() {
        SimpleBooleanReference br1 = new SimpleBooleanReference(true);
        SimpleBooleanReferenceTests.assertEquals((String)"[true]", (String)br1.toString());
        br1.setFalse();
        SimpleBooleanReferenceTests.assertEquals((String)"[false]", (String)br1.toString());
    }
}

