/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloneIterableTests
extends TestCase {
    Iterable<String> iterable;

    public CloneIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("0");
        c.add("1");
        c.add("2");
        c.add("3");
        CloneIterableTests.assertEquals((int)4, (int)c.size());
        this.iterable = this.buildIterable(c);
        int i = 0;
        for (String s : this.iterable) {
            CloneIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
            c.remove("3");
        }
        CloneIterableTests.assertEquals((int)4, (int)i);
        CloneIterableTests.assertEquals((int)3, (int)c.size());
    }

    public void testRemove() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildRemovingIterable(collection);
        String removed = "three";
        CloneIterableTests.assertTrue((boolean)CollectionTools.contains(this.iterable, (Object)removed));
        Iterator<String> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            iterator.remove();
        }
        CloneIterableTests.assertFalse((boolean)collection.contains(removed));
    }

    public void testRemover() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterableWithRemover(collection);
        String removed = "three";
        CloneIterableTests.assertTrue((boolean)CollectionTools.contains(this.iterable, (Object)removed));
        Iterator<String> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            iterator.remove();
        }
        CloneIterableTests.assertFalse((boolean)collection.contains(removed));
    }

    public void testMissingRemover() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        CloneIterableTests.assertNotNull((Object)this.iterable.toString());
        String removed = "three";
        CloneIterableTests.assertTrue((boolean)CollectionTools.contains(this.iterable, (Object)removed));
        boolean exCaught = false;
        Iterator<String> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            try {
                iterator.remove();
                CloneIterableTests.fail();
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
        }
        CloneIterableTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        CloneIterableTests.assertNotNull((Object)this.iterable.toString());
    }

    abstract Iterable<String> buildIterable(List<String> var1);

    abstract Iterable<String> buildRemovingIterable(List<String> var1);

    abstract Iterable<String> buildIterableWithRemover(List<String> var1);

    CloneIterator.Remover<String> buildRemover(final Collection<String> c) {
        return new CloneIterator.Remover<String>(){

            public void remove(String current) {
                c.remove(current);
            }
        };
    }

    CloneListIterator.Mutator<String> buildMutator(final List<String> list) {
        return new CloneListIterator.Mutator<String>(){

            public void add(int index, String string) {
                list.add(index, string);
            }

            public void set(int index, String string) {
                list.set(index, string);
            }

            public void remove(int index) {
                list.remove(index);
            }
        };
    }

    List<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        c.add("six");
        c.add("seven");
        c.add("eight");
        return c;
    }
}

