/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.SynchronizedIterator;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedIteratorTests
extends MultiThreadedTestCase {
    public SynchronizedIteratorTests(String name) {
        super(name);
    }

    public void testUnsynchronizedNext() throws Exception {
        TestIterator<String> iterator = this.buildTestIterator(TWO_TICKS);
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        NextTestRunnable<String> runnable2 = new NextTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        iterator.slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertEquals((String)"foo", (String)((String)runnable2.next));
    }

    public void testSynchronizedNext() throws Exception {
        TestIterator<String> nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator<String> iterator = this.buildSynchronizedIterator(nestedIterator);
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        NextTestRunnable<String> runnable2 = new NextTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        nestedIterator.slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertEquals((String)"bar", (String)((String)runnable2.next));
    }

    public void testUnsynchronizedHasNext() throws Exception {
        TestIterator<String> iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        iterator.next();
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        HasNextTestRunnable<String> runnable2 = new HasNextTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        iterator.slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"baz", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertEquals((boolean)true, (boolean)runnable2.hasNext);
    }

    public void testSynchronizedHasNext() throws Exception {
        TestIterator<String> nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator<String> iterator = this.buildSynchronizedIterator(nestedIterator);
        iterator.next();
        iterator.next();
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        HasNextTestRunnable<String> runnable2 = new HasNextTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        nestedIterator.slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"baz", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertEquals((boolean)false, (boolean)runnable2.hasNext);
    }

    public void testUnsynchronizedRemove() throws Exception {
        TestIterator<String> iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        RemoveTestRunnable<String> runnable2 = new RemoveTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        iterator.slowThread = thread1;
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertFalse((boolean)iterator.list.contains("foo"));
        SynchronizedIteratorTests.assertTrue((boolean)iterator.list.contains("bar"));
        SynchronizedIteratorTests.assertTrue((boolean)iterator.list.contains("baz"));
    }

    public void testSynchronizedRemove() throws Exception {
        TestIterator<String> nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator<String> iterator = this.buildSynchronizedIterator(nestedIterator);
        iterator.next();
        NextTestRunnable<String> runnable1 = new NextTestRunnable<String>(iterator);
        Thread thread1 = this.buildThread(runnable1);
        RemoveTestRunnable<String> runnable2 = new RemoveTestRunnable<String>(iterator);
        Thread thread2 = this.buildThread(runnable2);
        nestedIterator.slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedIteratorTests.assertTrue((boolean)nestedIterator.list.contains("foo"));
        SynchronizedIteratorTests.assertFalse((boolean)nestedIterator.list.contains("bar"));
        SynchronizedIteratorTests.assertTrue((boolean)nestedIterator.list.contains("baz"));
    }

    TestIterator<String> buildTestIterator(long delay) {
        return new TestIterator<String>(delay, this.buildArray());
    }

    String[] buildArray() {
        return new String[]{"foo", "bar", "baz"};
    }

    Iterator<String> buildSynchronizedIterator(Iterator<String> nestedIterator) {
        return new SynchronizedIterator(nestedIterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HasNextTestRunnable<E>
    implements Runnable {
        final Iterator<E> iterator;
        boolean hasNext;

        HasNextTestRunnable(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.hasNext = this.iterator.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NextTestRunnable<E>
    implements Runnable {
        final Iterator<E> iterator;
        E next;

        NextTestRunnable(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.next = this.iterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RemoveTestRunnable<E>
    implements Runnable {
        final Iterator<E> iterator;

        RemoveTestRunnable(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestIterator<E>
    implements Iterator<E> {
        final long delay;
        final ArrayList<E> list = new ArrayList();
        int nextIndex = 0;
        int lastIndex = -1;
        Thread slowThread;

        TestIterator(long delay, E ... array) {
            this.delay = delay;
            CollectionTools.addAll(this.list, (Object[])array);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != this.list.size();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E next = this.list.get(this.nextIndex);
                if (Thread.currentThread() == this.slowThread) {
                    TestTools.sleep(this.delay);
                }
                this.lastIndex = this.nextIndex++;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.lastIndex);
            if (this.lastIndex < this.nextIndex) {
                --this.nextIndex;
            }
            this.lastIndex = -1;
        }
    }
}

