/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.SpinnerModelAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class SpinnerModelAdapterTests
extends TestCase {
    private ModifiablePropertyValueModel<Object> valueHolder;
    SpinnerModel spinnerModelAdapter;
    boolean eventFired;

    public SpinnerModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.valueHolder = new SimplePropertyValueModel((Object)new Integer(0));
        this.spinnerModelAdapter = new SpinnerModelAdapter(this.valueHolder){

            protected PropertyChangeListener buildValueListener() {
                return this.buildValueListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetValueSpinnerModel() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerModelAdapterTests.this.eventFired = true;
                SpinnerModelAdapterTests.assertEquals((Object)SpinnerModelAdapterTests.this.spinnerModelAdapter, (Object)e.getSource());
            }
        });
        this.spinnerModelAdapter.setValue(new Integer(5));
        SpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        SpinnerModelAdapterTests.assertEquals((Object)new Integer(5), (Object)this.valueHolder.getValue());
    }

    public void testSetValueValueHolder() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerModelAdapterTests.this.eventFired = true;
                SpinnerModelAdapterTests.assertEquals((Object)SpinnerModelAdapterTests.this.spinnerModelAdapter, (Object)e.getSource());
            }
        });
        SpinnerModelAdapterTests.assertEquals((Object)new Integer(0), (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue((Object)new Integer(7));
        SpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        SpinnerModelAdapterTests.assertEquals((Object)new Integer(7), (Object)this.spinnerModelAdapter.getValue());
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localValueHolder = (SimplePropertyValueModel)this.valueHolder;
        SpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.spinnerModelAdapter.addChangeListener(listener);
        SpinnerModelAdapterTests.assertTrue((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.spinnerModelAdapter);
        this.spinnerModelAdapter.removeChangeListener(listener);
        SpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
    }

    private void verifyHasNoListeners(Object adapter) throws Exception {
        Object delegate = ReflectionTools.getFieldValue((Object)adapter, (String)"delegate");
        Object[] listeners = (Object[])ReflectionTools.executeMethod((Object)delegate, (String)"getChangeListeners");
        SpinnerModelAdapterTests.assertEquals((int)0, (int)listeners.length);
    }

    private void verifyHasListeners(Object adapter) throws Exception {
        Object delegate = ReflectionTools.getFieldValue((Object)adapter, (String)"delegate");
        Object[] listeners = (Object[])ReflectionTools.executeMethod((Object)delegate, (String)"getChangeListeners");
        SpinnerModelAdapterTests.assertFalse((listeners.length == 0 ? 1 : 0) != 0);
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            SpinnerModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

