/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTConverterBindingsTest
extends ConverterTestSetup {
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$0;

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public ASTConverterBindingsTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterBindingsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTConverterBindingsTest.buildModelTestSuite(clazz);
    }

    public void test0001() throws JavaScriptModelException {
        this.checkBindingEqualityForProject("Converter");
        this.checkBindingEqualityForProject("Converter15");
    }

    private void checkBindingEqualityForProject(String projectName) throws JavaScriptModelException {
        IJavaScriptProject javaProject = this.getJavaProject(projectName);
        IPackageFragment[] packageFragments = javaProject.getPackageFragments();
        ArrayList<IJavaScriptUnit> compilationUnitscollector = new ArrayList<IJavaScriptUnit>();
        int j = 0;
        int max2 = packageFragments.length;
        while (j < max2) {
            IJavaScriptUnit[] units = packageFragments[j].getJavaScriptUnits();
            if (units != null) {
                int k = 0;
                int max3 = units.length;
                while (k < max3) {
                    compilationUnitscollector.add(units[k]);
                    ++k;
                }
            }
            ++j;
        }
        int length = compilationUnitscollector.size();
        IJavaScriptUnit[] units = new IJavaScriptUnit[length];
        compilationUnitscollector.toArray(units);
        int j2 = 0;
        while (j2 < length) {
            IJavaScriptUnit currentUnit = units[j2];
            ASTNode result = this.runConversion(3, currentUnit, true);
            ASTConverterBindingsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)result.getNodeType());
            JavaScriptUnit unit = (JavaScriptUnit)result;
            result = this.runConversion(3, currentUnit, true);
            ASTConverterBindingsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)result.getNodeType());
            JavaScriptUnit unit2 = (JavaScriptUnit)result;
            BindingsCollector collector = new BindingsCollector();
            unit.accept((ASTVisitor)collector);
            List bindings1 = collector.getBindings();
            BindingsCollector collector2 = new BindingsCollector();
            unit2.accept((ASTVisitor)collector2);
            List bindings2 = collector2.getBindings();
            ASTConverterBindingsTest.assertEquals((String)"Wrong size", (int)bindings1.size(), (int)bindings2.size());
            long time = System.currentTimeMillis();
            int i = 0;
            int max = bindings1.size();
            while (i < max) {
                Object object = bindings1.get(i);
                ASTConverterBindingsTest.assertTrue((String)"not a binding", (boolean)(object instanceof IBinding));
                IBinding binding = (IBinding)object;
                Object object2 = bindings2.get(i);
                ASTConverterBindingsTest.assertTrue((String)"not a binding", (boolean)(object2 instanceof IBinding));
                IBinding binding2 = (IBinding)object2;
                boolean equalTo = binding.isEqualTo(binding2);
                ASTConverterBindingsTest.assertTrue((String)"not equals", (boolean)equalTo);
                ++i;
            }
            System.currentTimeMillis();
            ++j2;
        }
    }

    static class BindingsCollector
    extends ASTVisitor {
        public ArrayList arrayList = new ArrayList();

        BindingsCollector() {
            super(true);
        }

        private void collectBindings(ASTNode node, IBinding binding) {
            if (binding != null) {
                this.arrayList.add(binding);
            }
        }

        public void endVisit(AnonymousClassDeclaration node) {
            ITypeBinding typeBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ArrayAccess node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ArrayCreation node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ArrayInitializer node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ArrayType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(Assignment node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(BooleanLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(CharacterLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ClassInstanceCreation node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ConditionalExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ConstructorInvocation node) {
            IFunctionBinding methodBinding = node.resolveConstructorBinding();
            this.collectBindings((ASTNode)node, (IBinding)methodBinding);
        }

        public void endVisit(FieldAccess node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ImportDeclaration node) {
            IBinding binding = node.resolveBinding();
            this.collectBindings((ASTNode)node, binding);
        }

        public void endVisit(InfixExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(InstanceofExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ListExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(MemberRef node) {
            IBinding binding = node.resolveBinding();
            this.collectBindings((ASTNode)node, binding);
        }

        public void endVisit(FunctionDeclaration node) {
            IFunctionBinding methodBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)methodBinding);
        }

        public void endVisit(FunctionInvocation node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(FunctionRef node) {
            IBinding binding = node.resolveBinding();
            this.collectBindings((ASTNode)node, binding);
        }

        public void endVisit(NullLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(NumberLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(PackageDeclaration node) {
            IPackageBinding packageBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)packageBinding);
        }

        public void endVisit(ParenthesizedExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(PostfixExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(PrefixExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(PrimitiveType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(QualifiedName node) {
            IBinding binding = node.resolveBinding();
            this.collectBindings((ASTNode)node, binding);
        }

        public void endVisit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            this.collectBindings((ASTNode)node, binding);
        }

        public void endVisit(SimpleType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(SingleVariableDeclaration node) {
            IVariableBinding variableBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)variableBinding);
        }

        public void endVisit(StringLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(SuperConstructorInvocation node) {
            IFunctionBinding methodBinding = node.resolveConstructorBinding();
            this.collectBindings((ASTNode)node, (IBinding)methodBinding);
        }

        public void endVisit(SuperFieldAccess node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(SuperMethodInvocation node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(ThisExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(TypeDeclaration node) {
            ITypeBinding typeBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(TypeLiteral node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(VariableDeclarationExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            this.collectBindings((ASTNode)node, (IBinding)typeBinding);
        }

        public void endVisit(VariableDeclarationFragment node) {
            IVariableBinding variableBinding = node.resolveBinding();
            this.collectBindings((ASTNode)node, (IBinding)variableBinding);
        }

        public List getBindings() {
            return this.arrayList;
        }
    }
}

