/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;

public class SWTListChangeListenerWrapper
implements ListChangeListener {
    private final ListChangeListener listener;

    public SWTListChangeListenerWrapper(ListChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(ListAddEvent event) {
        this.execute((Runnable)((Object)new ItemsAddedRunnable(event)));
    }

    void itemsAdded_(ListAddEvent event) {
        this.listener.itemsAdded(event);
    }

    public void itemsRemoved(ListRemoveEvent event) {
        this.execute((Runnable)((Object)new ItemsRemovedRunnable(event)));
    }

    void itemsRemoved_(ListRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    public void itemsMoved(ListMoveEvent event) {
        this.execute((Runnable)((Object)new ItemsMovedRunnable(event)));
    }

    void itemsMoved_(ListMoveEvent event) {
        this.listener.itemsMoved(event);
    }

    public void itemsReplaced(ListReplaceEvent event) {
        this.execute((Runnable)((Object)new ItemsReplacedRunnable(event)));
    }

    public void listCleared(ListClearEvent event) {
        this.execute((Runnable)((Object)new ListClearedRunnable(event)));
    }

    void itemsReplaced_(ListReplaceEvent event) {
        this.listener.itemsReplaced(event);
    }

    void listCleared_(ListClearEvent event) {
        this.listener.listCleared(event);
    }

    public void listChanged(ListChangeEvent event) {
        this.execute((Runnable)((Object)new ListChangedRunnable(event)));
    }

    void listChanged_(ListChangeEvent event) {
        this.listener.listChanged(event);
    }

    private void execute(Runnable r) {
        SWTUtil.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class ItemsAddedRunnable
    extends RunnableAdapter {
        private final ListAddEvent event;

        ItemsAddedRunnable(ListAddEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.itemsAdded_(this.event);
        }
    }

    class ItemsMovedRunnable
    extends RunnableAdapter {
        private final ListMoveEvent event;

        ItemsMovedRunnable(ListMoveEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.itemsMoved_(this.event);
        }
    }

    class ItemsRemovedRunnable
    extends RunnableAdapter {
        private final ListRemoveEvent event;

        ItemsRemovedRunnable(ListRemoveEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.itemsRemoved_(this.event);
        }
    }

    class ItemsReplacedRunnable
    extends RunnableAdapter {
        private final ListReplaceEvent event;

        ItemsReplacedRunnable(ListReplaceEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.itemsReplaced_(this.event);
        }
    }

    class ListChangedRunnable
    extends RunnableAdapter {
        private final ListChangeEvent event;

        ListChangedRunnable(ListChangeEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.listChanged_(this.event);
        }
    }

    class ListClearedRunnable
    extends RunnableAdapter {
        private final ListClearEvent event;

        ListClearedRunnable(ListClearEvent event) {
            this.event = event;
        }

        public void run() {
            SWTListChangeListenerWrapper.this.listCleared_(this.event);
        }
    }
}

