/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.util;

import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlSwitcher {
    private PageBook pageBook;
    private Transformer<?, Control> controlTransformer;
    private Label emptyLabel;

    public <T> ControlSwitcher(PropertyValueModel<? extends T> switchHolder, Transformer<T, Control> controlTransformer, PageBook pageBook) {
        this.initialize(switchHolder, controlTransformer, pageBook);
    }

    public <T> ControlSwitcher(PropertyValueModel<? extends T> switchHolder, Control control, PageBook pageBook) {
        this(switchHolder, ControlSwitcher.buildNullControlTransformer(control), pageBook);
    }

    private static <T> Transformer<T, Control> buildNullControlTransformer(final Control control) {
        return new Transformer<T, Control>(){

            public Control transform(T model) {
                if (model == null) {
                    return null;
                }
                return control;
            }
        };
    }

    private void initialize(PropertyValueModel<?> switchHolder, Transformer<?, Control> controlTransformer, PageBook pageBook) {
        this.pageBook = pageBook;
        this.controlTransformer = controlTransformer;
        this.emptyLabel = this.buildEmptyLabel();
        switchHolder.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        this.switchPages(switchHolder.getValue());
    }

    private Label buildEmptyLabel() {
        return new Label((Composite)this.pageBook, 290);
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildPropertyChangeListener_());
    }

    private PropertyChangeListener buildPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ControlSwitcher.this.switchPages(e.getNewValue());
            }
        };
    }

    private void switchPages(Object value) {
        if (this.pageBook.isDisposed()) {
            return;
        }
        Control page = this.transform(value);
        if (page == null) {
            page = this.emptyLabel;
        }
        this.pageBook.showPage(page);
        SWTUtil.reflow((Composite)this.pageBook);
    }

    private Control transform(Object value) {
        return (Control)this.controlTransformer.transform(value);
    }
}

