/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSafeCommandExecutor<E extends CommandExecutor>
implements CommandExecutor {
    protected final E commandExecutor;
    protected final ExceptionHandler exceptionHandler;

    protected AbstractSafeCommandExecutor(E commandExecutor) {
        this(commandExecutor, ExceptionHandler.Null.instance());
    }

    protected AbstractSafeCommandExecutor(E commandExecutor, ExceptionHandler exceptionHandler) {
        if (commandExecutor == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(Command command) {
        try {
            this.commandExecutor.execute(command);
        }
        catch (RuntimeException ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.commandExecutor);
    }
}

