/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.command.RepeatingCommand;
import org.eclipse.jpt.common.utility.internal.StackTrace;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.command.RepeatingCommandState;

public class RepeatingCommandWrapper
implements RepeatingCommand {
    final Command command;
    private final Command startCommand;
    private final CommandExecutor startCommandExecutor;
    final ExceptionHandler exceptionHandler;
    final RepeatingCommandState state;
    private final ArrayList<StackTrace> stackTraces = null;
    private static final boolean DEBUG = false;

    public RepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        this(command, CommandExecutor.Default.instance(), exceptionHandler);
    }

    public RepeatingCommandWrapper(Command command, CommandExecutor startCommandExecutor, ExceptionHandler exceptionHandler) {
        if (command == null || startCommandExecutor == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.startCommandExecutor = startCommandExecutor;
        this.startCommand = this.buildStartCommand();
        this.exceptionHandler = exceptionHandler;
        this.state = this.buildState();
    }

    private Command buildStartCommand() {
        return new StartCommand();
    }

    private RepeatingCommandState buildState() {
        return new RepeatingCommandState();
    }

    public void start() {
        this.state.start();
    }

    public synchronized void execute() {
        if (this.state.isReadyToStartExecutionCycle()) {
            this.executeStartCommand();
        }
    }

    void executeStartCommand() {
        this.startCommandExecutor.execute(this.startCommand);
    }

    public void stop() throws InterruptedException {
        this.state.stop();
    }

    void execute_() {
        if (this.state.wasStoppedBeforeFirstExecutionCouldStart()) {
            return;
        }
        do {
            this.executeCommand();
        } while (this.state.isRepeat());
    }

    void executeCommand() {
        try {
            this.command.execute();
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.command);
    }

    class StartCommand
    implements Command {
        StartCommand() {
        }

        public void execute() {
            RepeatingCommandWrapper.this.execute_();
        }

        public String toString() {
            return StringTools.buildToStringFor(this, RepeatingCommandWrapper.this.command);
        }
    }
}

