/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWritablePropertyValueModel<V>
extends PropertyValueModelWrapper<V>
implements ModifiablePropertyValueModel<V> {
    protected volatile V bufferedValue;
    protected volatile boolean accepting;
    protected final PropertyValueModel<Boolean> triggerModel;
    protected final PropertyChangeListener triggerListener;
    protected volatile boolean buffering;

    public BufferedWritablePropertyValueModel(ModifiablePropertyValueModel<V> valueModel, PropertyValueModel<Boolean> triggerModel) {
        super(valueModel);
        if (triggerModel == null) {
            throw new NullPointerException();
        }
        this.triggerModel = triggerModel;
        this.bufferedValue = null;
        this.buffering = false;
        this.accepting = false;
        this.triggerListener = this.buildTriggerListener();
    }

    protected PropertyChangeListener buildTriggerListener() {
        return new TriggerListener();
    }

    @Override
    public V getValue() {
        return this.buffering ? this.bufferedValue : this.valueModel.getValue();
    }

    @Override
    public void setValue(V value) {
        if (this.buffering) {
            if (this.valuesAreEqual(value, this.valueModel.getValue())) {
                this.reset();
            } else {
                V old = this.bufferedValue;
                this.bufferedValue = value;
                this.firePropertyChanged("value", old, value);
            }
        } else if (!this.valuesAreEqual(value, this.valueModel.getValue())) {
            Object old = this.valueModel.getValue();
            this.bufferedValue = value;
            this.buffering = true;
            this.firePropertyChanged("value", old, value);
        }
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.triggerModel.addPropertyChangeListener("value", this.triggerListener);
    }

    @Override
    protected void disengageModel() {
        this.triggerModel.removePropertyChangeListener("value", this.triggerListener);
        super.disengageModel();
    }

    @Override
    protected void wrappedValueChanged(PropertyChangeEvent event) {
        if (!this.accepting) {
            this.wrappedValueChanged_(event);
        }
    }

    protected void wrappedValueChanged_(PropertyChangeEvent event) {
        if (this.buffering) {
            if (this.valuesAreEqual(event.getNewValue(), this.bufferedValue)) {
                this.reset();
            } else {
                this.handleChangeConflict(event);
            }
        } else {
            this.firePropertyChanged(event.clone(this));
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent event) {
    }

    protected void triggerChanged(PropertyChangeEvent event) {
        this.triggerChanged((Boolean)event.getNewValue());
    }

    protected void triggerChanged(boolean triggerValue) {
        if (this.buffering) {
            if (triggerValue) {
                this.accept();
            } else {
                this.reset();
            }
        }
    }

    protected void accept() {
        this.accepting = true;
        try {
            this.getValueModel().setValue(this.bufferedValue);
        }
        finally {
            this.bufferedValue = null;
            this.buffering = false;
            this.accepting = false;
        }
    }

    protected void reset() {
        V old = this.bufferedValue;
        this.bufferedValue = null;
        this.buffering = false;
        this.firePropertyChanged("value", old, this.valueModel.getValue());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    protected ModifiablePropertyValueModel<V> getValueModel() {
        return (ModifiablePropertyValueModel)this.valueModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Trigger
    extends SimplePropertyValueModel<Boolean> {
        @Override
        public Boolean getValue() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.getValue() may only be called during change notification.");
            }
            return (Boolean)this.value;
        }

        @Override
        public void setValue(Boolean value) {
            super.setValue(value);
            this.value = null;
        }

        @Override
        public void setValue(boolean value) {
            this.setValue((Boolean)value);
        }

        public boolean booleanValue() {
            return this.getValue();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }

    protected class TriggerListener
    extends PropertyChangeAdapter {
        protected TriggerListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            BufferedWritablePropertyValueModel.this.triggerChanged(event);
        }
    }
}

