/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.dbws.eclipselink.ui.JptDbwsUiPlugin;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.DbwsGeneratorUi;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.JptDbwsUiMessages;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen.BuilderXmlWizardPage;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen.JdbcDriverWizardPage;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen.WebDynamicProjectWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class DbwsGeneratorWizard
extends Wizard
implements IWorkbenchWizard {
    private IJavaProject javaProject;
    private String builderXmlFile;
    private IStructuredSelection selection;
    private WebDynamicProjectWizardPage projectWizardPage;
    private BuilderXmlWizardPage builderXmlWizardPage;
    private static final String WIZARD_NAME = DbwsGeneratorWizard.class.getName();
    private static final String DBWS_SECTION_NAME = "DbwsSettings";
    private JdbcDriverWizardPage jdbcDriversPage;

    public DbwsGeneratorWizard() {
        this.initialize();
    }

    public DbwsGeneratorWizard(IJavaProject javaProject, String builderXmlFile) {
        this.javaProject = javaProject;
        this.builderXmlFile = builderXmlFile;
        this.initialize();
    }

    private void initialize() {
        if (this.getDialogSettings() == null) {
            IDialogSettings dbwsSettings = JptDbwsUiPlugin.instance().getDialogSettings();
            IDialogSettings wizardSettings = dbwsSettings.getSection(DBWS_SECTION_NAME);
            if (wizardSettings == null) {
                wizardSettings = dbwsSettings.addNewSection(DBWS_SECTION_NAME);
            }
            this.setDialogSettings(wizardSettings);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(JptDbwsUiMessages.DbwsGeneratorWizard_title);
        this.setDefaultPageImageDescriptor(JptDbwsUiPlugin.getImageDescriptor("full/wizban/webservicesclient_wiz"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.selection != null) {
            this.javaProject = this.getJavaProjectFromSelection(this.selection);
            this.projectWizardPage = this.buildWebDynamicProjectPage(this.javaProject);
            this.addPage((IWizardPage)this.projectWizardPage);
            IFile builderXmlSelected = BuilderXmlWizardPage.getBuilderXmlFromSelection(this.selection);
            if (builderXmlSelected == null) {
                this.builderXmlWizardPage = this.buildBuilderXmlPage(this.selection);
                this.addPage((IWizardPage)this.builderXmlWizardPage);
            } else {
                this.builderXmlFile = this.makeRelativeToProjectPath(builderXmlSelected.getFullPath());
            }
        }
        this.jdbcDriversPage = this.buildJdbcDriversPage();
        this.addPage((IWizardPage)this.jdbcDriversPage);
    }

    public boolean performFinish() {
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        if (currentPage != null && !currentPage.isPageComplete()) {
            return false;
        }
        String driverJarList = this.jdbcDriversPage.getDriverJarList();
        this.jdbcDriversPage.finish();
        if (DbwsGeneratorUi.displayOverridingWebContentWarning(this.getShell())) {
            this.generateDbws(driverJarList);
        }
        return true;
    }

    public IJavaProject getJavaProject() {
        if (this.projectWizardPage != null) {
            this.javaProject = this.projectWizardPage.getJavaProject();
        }
        return this.javaProject;
    }

    public String getBuilderXmlPathOrUri() {
        if (this.builderXmlWizardPage != null) {
            IFile xmlFile = this.builderXmlWizardPage.getBuilderXml();
            if (xmlFile != null) {
                return this.makeRelativeToProjectPath(xmlFile.getFullPath());
            }
            return this.builderXmlWizardPage.getSourceURI();
        }
        return this.builderXmlFile;
    }

    private WebDynamicProjectWizardPage buildWebDynamicProjectPage(IJavaProject javaProject) {
        WebDynamicProjectWizardPage projectWizardPage = new WebDynamicProjectWizardPage(javaProject);
        projectWizardPage.setTitle(JptDbwsUiMessages.WebDynamicProjectWizardPage_title);
        projectWizardPage.setDescription(JptDbwsUiMessages.WebDynamicProjectWizardPage_desc);
        projectWizardPage.setDestinationLabel(JptDbwsUiMessages.WebDynamicProjectWizardPage_destinationProject);
        return projectWizardPage;
    }

    private BuilderXmlWizardPage buildBuilderXmlPage(IStructuredSelection selection) {
        return new BuilderXmlWizardPage(selection);
    }

    private JdbcDriverWizardPage buildJdbcDriversPage() {
        return new JdbcDriverWizardPage(WIZARD_NAME);
    }

    private String makeRelativeToProjectPath(IPath path) {
        IPath relativePath = path.makeRelativeTo(this.getJavaProject().getProject().getFullPath());
        return relativePath.toOSString();
    }

    private void generateDbws(String driverJarList) {
        String stageDirName = this.getJavaProject().getProject().getLocation().toOSString();
        DbwsGeneratorUi.GenerateDbwsJob generateJob = new DbwsGeneratorUi.GenerateDbwsJob(this.getJavaProject(), this.getBuilderXmlPathOrUri(), stageDirName, driverJarList);
        generateJob.schedule();
    }

    private IJavaProject getJavaProjectFromSelection(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IJavaProject) {
            return (IJavaProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            IProject project = ((IResource)firstElement).getProject();
            return this.getJavaProjectFrom(project);
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject();
        }
        return null;
    }

    private IJavaProject getJavaProjectFrom(IProject project) {
        return ((IJavaElement)project.getAdapter(IJavaElement.class)).getJavaProject();
    }
}

