/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.Bag;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoordinatedBag<E>
implements Bag<E>,
CollectionChangeListener {
    private Bag<E> bag = new HashBag();

    CoordinatedBag(CollectionValueModel<E> cvm) {
        cvm.addCollectionChangeListener("values", (CollectionChangeListener)this);
    }

    public boolean add(E o) {
        return this.bag.add(o);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.bag.addAll(c);
    }

    public void clear() {
        this.bag.clear();
    }

    public boolean contains(Object o) {
        return this.bag.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.bag.containsAll(c);
    }

    public boolean isEmpty() {
        return this.bag.isEmpty();
    }

    public Iterator<E> iterator() {
        return this.bag.iterator();
    }

    public boolean remove(Object o) {
        return this.bag.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.bag.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.bag.retainAll(c);
    }

    public int size() {
        return this.bag.size();
    }

    public Object[] toArray() {
        return this.bag.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.bag.toArray((Object[])a);
    }

    public int count(Object o) {
        return this.bag.count(o);
    }

    public boolean add(E o, int count) {
        return this.bag.add(o, count);
    }

    public boolean remove(Object o, int count) {
        return this.bag.remove(o, count);
    }

    public Iterator<E> uniqueIterator() {
        return this.bag.uniqueIterator();
    }

    public int uniqueCount() {
        return this.bag.uniqueCount();
    }

    public Iterator<Bag.Entry<E>> entries() {
        return this.bag.entries();
    }

    public void itemsAdded(CollectionAddEvent event) {
        for (Object item : event.getItems()) {
            this.bag.add(item);
        }
    }

    public void itemsRemoved(CollectionRemoveEvent event) {
        for (Object item : event.getItems()) {
            this.bag.remove(item);
        }
    }

    public void collectionCleared(CollectionClearEvent event) {
        this.bag.clear();
    }

    public void collectionChanged(CollectionChangeEvent event) {
        this.bag.clear();
        CollectionTools.addAll(this.bag, (Iterator)((CollectionValueModel)event.getSource()).iterator());
    }

    public boolean equals(Object o) {
        return this.bag.equals(o);
    }

    public int hashCode() {
        return this.bag.hashCode();
    }

    public String toString() {
        return this.bag.toString();
    }
}

