/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataQueryHelper
implements IMetaDataQueryHelper {
    private IMetaDataModelManager _manager;
    private IMetaDataDomainContext _managerContext;

    public MetaDataQueryHelper(IMetaDataModelManager manager, IMetaDataDomainContext managerContext) {
        this._manager = manager;
        this._managerContext = managerContext;
    }

    @Override
    public Model getModel(String modelId) {
        return this.getMDModel(modelId);
    }

    @Override
    public Entity getEntity(String modelId, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet<Entity> rs = this.getEntities(modelId, entityKey, (IEntityQueryVisitor)visitor);
        return this.getFirstFromResultSet(rs);
    }

    @Override
    public IResultSet<Entity> getEntities(String modelId, String entityKey, IEntityQueryVisitor visitor) {
        Model model = this.getModel(modelId);
        return this.getEntities(model, entityKey, visitor);
    }

    @Override
    public Trait getTrait(Entity entity, String traitKey) {
        SimpleTraitQueryVisitorImpl visitor = new SimpleTraitQueryVisitorImpl();
        IResultSet<Trait> rs = this.getTraits(entity, traitKey, visitor);
        return this.getFirstFromResultSet(rs);
    }

    @Override
    public IResultSet<Trait> getTraits(Entity entity, String traitKey, ITraitQueryVisitor traitQueryVisitor) {
        IResultSet<Trait> rs = traitQueryVisitor.findTraits(entity, traitKey);
        return rs;
    }

    @Override
    public Entity getEntity(Entity initialEntityContext, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet<Entity> rs = this.getEntities(initialEntityContext, entityKey, (IEntityQueryVisitor)visitor);
        return this.getFirstFromResultSet(rs);
    }

    @Override
    public IResultSet<Entity> getEntities(Entity initialEntityContext, String entityQuery, IEntityQueryVisitor entityKeyQueryVisitor) {
        return entityKeyQueryVisitor.findEntities(initialEntityContext, entityQuery);
    }

    @Override
    public Trait getTrait(String modelId, String entityKey, String traitKey) {
        Entity entity = this.getEntity(modelId, entityKey);
        Trait t = null;
        if (entity != null) {
            t = this.getTrait(entity, traitKey);
        }
        return t;
    }

    @Override
    public <T> T getFirstFromResultSet(IResultSet<T> results) {
        T result = null;
        try {
            if (!results.getResults().isEmpty()) {
                result = results.getResults().get(0);
            }
            results.close();
        }
        catch (MetaDataException ex) {
            JSFCommonPlugin.log(4, "Error in getFirstFromResultSet()", ex);
        }
        return result;
    }

    private Model getMDModel(String modelId) {
        if (this._manager != null) {
            return this._manager.getModel(this.getModelContext(modelId));
        }
        return null;
    }

    protected IMetaDataModelContext getModelContext(String modelId) {
        return new MetaDataModelContext((IProject)this._managerContext.getAdapter(IProject.class), this._managerContext.getDomainId(), modelId);
    }
}

