/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsf.designtime.internal.BasicExtensionFactory;
import org.eclipse.jst.jsf.facelet.ui.internal.FaceletUiPlugin;
import org.eclipse.jst.jsf.facelet.ui.internal.validation.AbstractFaceletValidationStrategy;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLValidator
extends AbstractValidator
implements IValidator {
    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        if (resource == null || !(resource instanceof IFile)) {
            return vr;
        }
        IFile currentFile = (IFile)resource;
        List<AbstractFaceletValidationStrategy> validationStrategies = this.getStrategies(currentFile.getProject());
        for (AbstractFaceletValidationStrategy strategy : validationStrategies) {
            if (!strategy.shouldValidate(currentFile)) continue;
            strategy.validateFile(currentFile, vr.getReporter(monitor), this);
        }
        return vr;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                if (currentFile != null && currentFile.exists()) {
                    List<AbstractFaceletValidationStrategy> validationStrategies = this.getStrategies(currentFile.getProject());
                    for (AbstractFaceletValidationStrategy strategy : validationStrategies) {
                        if (!strategy.shouldValidate(currentFile)) continue;
                        int percent = i * 100 / uris.length + 1;
                        LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + uris[i]);
                        reporter.displaySubtask((IValidator)this, (IMessage)message);
                        strategy.validateFile(currentFile, reporter, this);
                    }
                }
                ++i;
            }
        }
    }

    private List<AbstractFaceletValidationStrategy> getStrategies(IProject project) {
        Map<String, BasicExtensionFactory.ExtensionData<AbstractFaceletValidationStrategy>> possibleStrategies = FaceletUiPlugin.getDefault().getValidationStrategy();
        ArrayList<AbstractFaceletValidationStrategy> strategies = new ArrayList<AbstractFaceletValidationStrategy>(possibleStrategies.size());
        int maxPriority = 0;
        for (Map.Entry<String, BasicExtensionFactory.ExtensionData<AbstractFaceletValidationStrategy>> entry : possibleStrategies.entrySet()) {
            AbstractFaceletValidationStrategy instance = (AbstractFaceletValidationStrategy)entry.getValue().getInstance(project);
            if (instance == null) continue;
            int priority = instance.getPriority();
            if (priority > maxPriority) {
                strategies.clear();
                maxPriority = priority;
                strategies.add(instance);
            }
            if (priority != maxPriority) continue;
            strategies.add(instance);
        }
        return strategies;
    }
}

