/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.IntReference;
import org.eclipse.jpt.common.utility.internal.ModifiableIntReference;

public final class SimpleIntReference
implements ModifiableIntReference,
Cloneable,
Serializable {
    private volatile int value = 0;
    private static final long serialVersionUID = 1L;

    public SimpleIntReference(int count) {
        this.value = count;
    }

    public SimpleIntReference() {
        this(0);
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(int v) {
        return this.value == v;
    }

    public boolean notEqual(int v) {
        return this.value != v;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean isNotZero() {
        return this.value != 0;
    }

    public boolean isGreaterThan(int v) {
        return this.value > v;
    }

    public boolean isGreaterThanOrEqual(int v) {
        return this.value >= v;
    }

    public boolean isLessThan(int v) {
        return this.value < v;
    }

    public boolean isLessThanOrEqual(int v) {
        return this.value <= v;
    }

    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    public boolean isNegative() {
        return this.isLessThan(0);
    }

    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    public int abs() {
        return Math.abs(this.value);
    }

    public int neg() {
        return -this.value;
    }

    public int add(int v) {
        return this.value + v;
    }

    public int subtract(int v) {
        return this.value - v;
    }

    public int multiply(int v) {
        return this.value * v;
    }

    public int divide(int v) {
        return this.value / v;
    }

    public int remainder(int v) {
        return this.value % v;
    }

    public int min(int v) {
        return Math.min(this.value, v);
    }

    public int max(int v) {
        return Math.max(this.value, v);
    }

    public double pow(int v) {
        return Math.pow(this.value, v);
    }

    public int setValue(int value) {
        int old = this.value;
        this.value = value;
        return old;
    }

    public int setZero() {
        return this.setValue(0);
    }

    public int increment() {
        return ++this.value;
    }

    public int decrement() {
        return --this.value;
    }

    public int compareTo(IntReference ref) {
        int v = ref.getValue();
        return this.value < v ? -1 : (this.value == v ? 0 : 1);
    }

    public SimpleIntReference clone() {
        try {
            return (SimpleIntReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

