/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.weave;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.eclipselink.core.builder.EclipseLinkStaticWeavingBuilderConfigurator;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.LoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class EclipselinkPreferencePage
extends PropertyPage {
    private EclipseLinkStaticWeavingBuilderConfigurator configurator;
    private StaticWeavingComposite staticWeavingComposite;

    public EclipselinkPreferencePage() {
        this.setDescription(EclipseLinkUiMessages.EclipselinkPreferencePage_description);
    }

    public boolean performOk() {
        super.performOk();
        if (this.staticWeaveClasses()) {
            if (!this.projectHasStaticWeavingBuilder()) {
                this.configurator.addBuilder();
            }
            this.updateProjectStaticWeavingPreferences();
        } else {
            this.configurator.removeBuilder();
            this.removeProjectStaticWeavingPreferences();
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        this.configurator = new EclipseLinkStaticWeavingBuilderConfigurator(this.getProject());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.noDefaultAndApplyButton();
        this.staticWeavingComposite = new StaticWeavingComposite(composite);
        return composite;
    }

    private void updateProjectStaticWeavingPreferences() {
        String location = StringTools.stringIsEmpty((String)this.getSourceFolder()) ? this.getDefaultSource() : this.getSourceFolder();
        this.configurator.setSourceLocationPreference(location);
        location = StringTools.stringIsEmpty((String)this.getTargetFolder()) ? this.getDefaultTarget() : this.getTargetFolder();
        this.configurator.setTargetLocationPreference(location);
        location = StringTools.stringIsEmpty((String)this.getPersistenceInfo()) ? this.getDefaultPersistenceInfo() : this.getPersistenceInfo();
        this.configurator.setPersistenceInfoPreference(location);
        this.configurator.setLogLevelPreference(this.getLogLevel());
    }

    private void removeProjectStaticWeavingPreferences() {
        this.configurator.removeSourceLocationPreference();
        this.configurator.removeTargetLocationPreference();
        this.configurator.removeLogLevelPreference();
        this.configurator.removePersistenceInfoPreference();
    }

    private boolean projectHasStaticWeavingBuilder() {
        return this.configurator.projectHasStaticWeavingBuilder();
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        return adaptable == null ? null : (IProject)adaptable.getAdapter(IProject.class);
    }

    private String makeRelativeToProjectPath(String filePath) {
        Path path = new Path(filePath);
        IPath relativePath = path.makeRelativeTo(this.getProject().getLocation());
        return relativePath.toOSString();
    }

    private boolean staticWeaveClasses() {
        return this.staticWeavingComposite.getStaticWeaveCheckBoxValue();
    }

    private String getSourceFolder() {
        return this.staticWeavingComposite.getSourceFolder();
    }

    private String getTargetFolder() {
        return this.staticWeavingComposite.getTargetFolder();
    }

    private String getPersistenceInfo() {
        return this.staticWeavingComposite.getPersistenceInfoFolder();
    }

    private String getLogLevel() {
        return this.staticWeavingComposite.getLogLevel();
    }

    private String getSourcePreference() {
        return this.configurator.getSourceLocationPreference();
    }

    private String getTargetPreference() {
        return this.configurator.getTargetLocationPreference();
    }

    private String getPersistenceInfoPreference() {
        return this.configurator.getPersistenceInfoPreference();
    }

    private String getLogLevelPreference() {
        return this.configurator.getLogLevelPreference();
    }

    private String getDefaultSource() {
        return this.configurator.getDefaultSourceLocation();
    }

    private String getDefaultTarget() {
        return this.configurator.getDefaultTargetLocation();
    }

    private String getDefaultPersistenceInfo() {
        return this.configurator.getDefaultPersistenceInfo();
    }

    private String getDefaultLogLevel() {
        return this.configurator.getDefaultLogLevel();
    }

    class StaticWeavingComposite {
        private final Button staticWeaveClassesCheckBox;
        private final Label sourceLabel;
        private final Text sourceFolderText;
        private final Button browseSourceButton;
        private final Label targetLabel;
        private final Text targetFolderText;
        private final Button browseTargetButton;
        private final Label persistenceInfoLabel;
        private final Text persistenceInfoText;
        private final Button browsePersistenceInfoButton;
        private final Label logLevelLabel;
        private final Combo logLevelComboBox;
        private String logLevel;

        private StaticWeavingComposite(Composite parent) {
            Group weavingGroup = new Group(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = EclipselinkPreferencePage.this.convertVerticalDLUsToPixels(0);
            weavingGroup.setLayout((Layout)layout);
            weavingGroup.setLayoutData((Object)new GridData(768));
            weavingGroup.setText(EclipseLinkUiMessages.EclipselinkPreferencePage_staticWeavingGroupBox);
            this.staticWeaveClassesCheckBox = this.buildStaticWeaveCheckBox((Composite)weavingGroup, EclipseLinkUiMessages.EclipselinkPreferencePage_weaveClassesOnBuildLabel, this.buildStaticWeaveCheckBoxListener(), 3);
            this.sourceLabel = this.buildLabel((Composite)weavingGroup, 1, EclipseLinkUiMessages.EclipselinkPreferencePage_sourceLabel);
            this.sourceFolderText = this.buildText((Composite)weavingGroup, 1);
            this.browseSourceButton = this.buildBrowseButton((Composite)weavingGroup, this.buildBrowseSourceButtonSelectionListener(EclipseLinkUiMessages.EclipselinkPreferencePage_selectSourceLabel, EclipseLinkUiMessages.EclipselinkPreferencePage_sourceFolderSelectionLabel));
            this.targetLabel = this.buildLabel((Composite)weavingGroup, 1, EclipseLinkUiMessages.EclipselinkPreferencePage_targetLabel);
            this.targetFolderText = this.buildText((Composite)weavingGroup, 1);
            this.browseTargetButton = this.buildBrowseButton((Composite)weavingGroup, this.buildBrowseTargetButtonSelectionListener(EclipseLinkUiMessages.EclipselinkPreferencePage_selectTargetLabel, EclipseLinkUiMessages.EclipselinkPreferencePage_targetFolderSelectionLabel));
            this.logLevelLabel = this.buildLabel((Composite)weavingGroup, 1, EclipseLinkUiMessages.EclipselinkPreferencePage_logLevelLabel);
            this.logLevelComboBox = this.buildLogLevelComboBox((Composite)weavingGroup, 1);
            this.buildFiller((Composite)weavingGroup);
            this.persistenceInfoLabel = this.buildLabel((Composite)weavingGroup, 1, EclipseLinkUiMessages.EclipselinkPreferencePage_persistenceInfoLabel);
            this.persistenceInfoText = this.buildText((Composite)weavingGroup, 1);
            this.browsePersistenceInfoButton = this.buildBrowseButton((Composite)weavingGroup, this.buildBrowsePersistenceInfoButtonSelectionListener(EclipseLinkUiMessages.EclipselinkPreferencePage_selectPersistenceInfoLabel, EclipseLinkUiMessages.EclipselinkPreferencePage_persistenceInfoFolderSelectionLabel));
            this.staticWeaveClassesCheckBox.setSelection(EclipselinkPreferencePage.this.projectHasStaticWeavingBuilder());
            this.staticWeaveCheckBoxChanged();
        }

        private SelectionListener buildStaticWeaveCheckBoxListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    StaticWeavingComposite.this.staticWeaveCheckBoxChanged();
                }
            };
        }

        private void staticWeaveCheckBoxChanged() {
            boolean enabled = this.getStaticWeaveCheckBoxValue();
            this.setSourceEnabled(enabled);
            this.setTargetEnabled(enabled);
            this.setPersistenceInfoEnabled(enabled);
            this.setLogLevelEnabled(enabled);
            if (this.getStaticWeaveCheckBoxValue()) {
                this.initializeFromPreferences();
            } else {
                this.clearAll();
            }
        }

        private SelectionListener buildLogLevelComboBoxSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    StaticWeavingComposite.this.selectedLogLevelChanged();
                }

                public String toString() {
                    return "EclipselinkPreferencePage logLevel combo-box selection listener";
                }
            };
        }

        private void selectedLogLevelChanged() {
            this.logLevel = this.logLevelComboBox.getText();
        }

        private void initializeFromPreferences() {
            this.sourceFolderText.setText(EclipselinkPreferencePage.this.getSourcePreference());
            this.targetFolderText.setText(EclipselinkPreferencePage.this.getTargetPreference());
            String persistenceInfo = EclipselinkPreferencePage.this.getPersistenceInfoPreference() != null ? EclipselinkPreferencePage.this.getPersistenceInfoPreference() : "";
            this.persistenceInfoText.setText(persistenceInfo);
            this.logLevel = EclipselinkPreferencePage.this.getLogLevelPreference();
            this.logLevelComboBox.select(this.logLevelComboBox.indexOf(this.logLevel));
        }

        private void clearAll() {
            this.sourceFolderText.setText("");
            this.targetFolderText.setText("");
            this.persistenceInfoText.setText("");
            this.logLevel = EclipselinkPreferencePage.this.getDefaultLogLevel();
            this.logLevelComboBox.select(this.logLevelComboBox.indexOf(this.logLevel));
        }

        private void setSourceEnabled(boolean enabled) {
            this.sourceLabel.setEnabled(enabled);
            this.sourceFolderText.setEnabled(enabled);
            this.browseSourceButton.setEnabled(enabled);
        }

        private void setTargetEnabled(boolean enabled) {
            this.targetLabel.setEnabled(enabled);
            this.targetFolderText.setEnabled(enabled);
            this.browseTargetButton.setEnabled(enabled);
        }

        private void setPersistenceInfoEnabled(boolean enabled) {
            this.persistenceInfoLabel.setEnabled(enabled);
            this.persistenceInfoText.setEnabled(enabled);
            this.browsePersistenceInfoButton.setEnabled(enabled);
        }

        private void setLogLevelEnabled(boolean enabled) {
            this.logLevelLabel.setEnabled(enabled);
            this.logLevelComboBox.setEnabled(enabled);
        }

        private Button buildBrowseButton(Composite parent, SelectionListener selectionListener) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button browseButton = new Button(buttonComposite, 8);
            browseButton.setText(EclipseLinkUiMessages.EclipselinkPreferencePage_browse);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(selectionListener);
            return browseButton;
        }

        private SelectionListener buildBrowseSourceButtonSelectionListener(final String title, final String description) {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String directory = StaticWeavingComposite.this.promptFolder(title, description, StaticWeavingComposite.this.getSourceFolder());
                    if (!StringTools.stringIsEmpty((String)directory)) {
                        StaticWeavingComposite.this.sourceFolderText.setText(EclipselinkPreferencePage.this.makeRelativeToProjectPath(directory));
                    }
                }
            };
        }

        private SelectionListener buildBrowseTargetButtonSelectionListener(final String title, final String description) {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String directory = StaticWeavingComposite.this.promptFolder(title, description, StaticWeavingComposite.this.getTargetFolder());
                    if (!StringTools.stringIsEmpty((String)directory)) {
                        StaticWeavingComposite.this.targetFolderText.setText(EclipselinkPreferencePage.this.makeRelativeToProjectPath(directory));
                    }
                }
            };
        }

        private SelectionListener buildBrowsePersistenceInfoButtonSelectionListener(final String title, final String description) {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String directory = StaticWeavingComposite.this.promptFolder(title, description, StaticWeavingComposite.this.getPersistenceInfoFolder());
                    if (!StringTools.stringIsEmpty((String)directory)) {
                        StaticWeavingComposite.this.persistenceInfoText.setText(EclipselinkPreferencePage.this.makeRelativeToProjectPath(directory));
                    }
                }
            };
        }

        private Button buildStaticWeaveCheckBox(Composite parent, String text, SelectionListener listener, int horizontalSpan) {
            Button radioButton = new Button(parent, 32);
            GridData gridData = new GridData();
            gridData.horizontalSpan = horizontalSpan;
            radioButton.setLayoutData((Object)gridData);
            radioButton.setText(text);
            radioButton.addSelectionListener(listener);
            return radioButton;
        }

        private Text buildText(Composite parent, int horizontalSpan) {
            Text text = new Text(parent, 2052);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = horizontalSpan;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private Combo buildLogLevelComboBox(Composite parent, int horizontalSpan) {
            Combo combo = new Combo(parent, 2056);
            GridData gridData = new GridData(1, 0x1000000, true, false);
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = horizontalSpan;
            gridData.grabExcessHorizontalSpace = true;
            combo.setLayoutData((Object)gridData);
            combo.addSelectionListener(this.buildLogLevelComboBoxSelectionListener());
            this.populateLogLevelComboBox(combo);
            return combo;
        }

        private void buildFiller(Composite parent) {
            new Label(parent, 0);
        }

        private void populateLogLevelComboBox(Combo combo) {
            combo.removeAll();
            LoggingLevel[] loggingLevelArray = EclipselinkPreferencePage.this.configurator.getLogLevelValues();
            int n = loggingLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LoggingLevel value = loggingLevelArray[n2];
                combo.add(value.getPropertyValue());
                ++n2;
            }
        }

        private Label buildLabel(Composite parent, int span, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            GridData gridData = new GridData();
            gridData.horizontalSpan = span;
            label.setLayoutData((Object)gridData);
            return label;
        }

        private String getSourceFolder() {
            return this.sourceFolderText.getText();
        }

        private String getTargetFolder() {
            return this.targetFolderText.getText();
        }

        private String getPersistenceInfoFolder() {
            return this.persistenceInfoText.getText();
        }

        private String getLogLevel() {
            return this.logLevel;
        }

        private boolean getStaticWeaveCheckBoxValue() {
            return this.staticWeaveClassesCheckBox.getSelection();
        }

        private String promptFolder(String title, String description, String relativeLocation) {
            DirectoryDialog dialog = new DirectoryDialog(EclipselinkPreferencePage.this.getShell());
            dialog.setText(title);
            dialog.setMessage(description);
            dialog.setFilterPath(this.filterPath(relativeLocation));
            String directory = dialog.open();
            return directory;
        }

        protected String filterPath(String relativeLocation) {
            IPath location = EclipselinkPreferencePage.this.getProject().getLocation();
            if (!StringTools.stringIsEmpty((String)relativeLocation)) {
                location = location.append(relativeLocation);
            }
            return location.toPortableString();
        }
    }
}

