/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class PersistentTypeMapAsHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.eclipse.jpt.jpa.ui.persistentTypeMapAs";
    public static final String COMMAND_PARAMETER_ID = "persistentTypeMappingKey";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] items;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        String mappingKey = event.getParameter(COMMAND_PARAMETER_ID);
        Object[] objectArray = items = selection.toArray();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            PersistentType type = (PersistentType)item;
            type.setMappingKey(mappingKey);
            ++n2;
        }
        this.setJpaSelection(items);
        return null;
    }

    private void setJpaSelection(Object[] items) {
        if (items.length == 1) {
            new PostExecutionJob((PersistentType)items[0]).schedule();
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IEvaluationService es = (IEvaluationService)element.getServiceLocator().getService(IEvaluationService.class);
        IViewPart part = (IViewPart)es.getCurrentState().getVariable("activePart");
        IStructuredSelection selection = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
        String commonMappingKey = this.commonMappingKey(selection);
        String handlerMappingKey = (String)parameters.get(COMMAND_PARAMETER_ID);
        if (handlerMappingKey != null) {
            element.setChecked(handlerMappingKey.equals(commonMappingKey));
        }
    }

    protected String commonMappingKey(IStructuredSelection selection) {
        String commonKey = null;
        for (Object obj : selection) {
            if (!(obj instanceof PersistentType)) {
                return null;
            }
            PersistentType persistentType = (PersistentType)obj;
            if (commonKey == null) {
                commonKey = persistentType.getMappingKey();
                continue;
            }
            if (commonKey.equals(persistentType.getMappingKey())) continue;
            return null;
        }
        return commonKey;
    }

    static class PostExecutionJob
    extends Job {
        private final Runnable setSelectionRunnable;

        PostExecutionJob(PersistentType type) {
            super("select type");
            this.setSelectionRunnable = new SetSelectionRunnable(type);
            this.setRule((ISchedulingRule)type.getJpaProject().getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            SWTUtil.execute((Runnable)this.setSelectionRunnable);
            return Status.OK_STATUS;
        }

        static class SetSelectionRunnable
        extends RunnableAdapter {
            private final PersistentType type;

            SetSelectionRunnable(PersistentType type) {
                this.type = type;
            }

            public void run() {
                JpaSelectionManager mgr = (JpaSelectionManager)PlatformTools.getAdapter((Object)PlatformUI.getWorkbench(), JpaSelectionManager.class);
                mgr.setSelection(null);
                mgr.setSelection((JpaStructureNode)this.type);
            }
        }
    }
}

