/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.internal.utility.WorkspaceRunnableAdapter;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandExecutor;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectMappingFileDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class JavaMetadataConversionWizardPage
extends WizardPage {
    protected final JpaProject jpaProject;
    protected final PersistenceUnit persistenceUnit;
    protected final boolean noConvertibleJavaMetadata;
    private final SimplePropertyValueModel<String> mappingFileNameModel = new SimplePropertyValueModel();
    private static final String PAGE_NAME = "JavaMetadataConversion";
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jpa.ui.JavaMetadataConversion";

    protected JavaMetadataConversionWizardPage(JpaProject jpaProject, String title, String description) {
        super(PAGE_NAME);
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.persistenceUnit = this.buildPersistenceUnit();
        this.mappingFileNameModel.setValue((Object)this.buildDefaultMappingFileName());
        this.setTitle(title);
        this.setDescription(description);
        this.noConvertibleJavaMetadata = this.hasNoConvertibleJavaMetadata();
    }

    protected PersistenceUnit buildPersistenceUnit() {
        PersistenceXml persistenceXml = this.jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        ListIterator stream = persistence.getPersistenceUnits().iterator();
        return stream.hasNext() ? (PersistenceUnit)stream.next() : null;
    }

    protected String buildDefaultMappingFileName() {
        IPath path = this.buildDefaultMappingFilePath();
        return path == null ? null : path.toString();
    }

    protected IPath buildDefaultMappingFilePath() {
        IPath path = this.getFirstMappingFilePath();
        return path == null ? this.getDefaultMappingFileRuntimPath() : this.convertToRuntimPath(path);
    }

    protected abstract IPath getDefaultMappingFileRuntimPath();

    protected IPath getFirstMappingFilePath() {
        if (this.persistenceUnit == null) {
            return null;
        }
        for (MappingFileRef ref : this.persistenceUnit.getMappingFileRefs()) {
            IFile file;
            MappingFile mappingFile = ref.getMappingFile();
            if (mappingFile == null || !this.jpaProject.getJpaFile(file = mappingFile.getXmlResource().getFile()).getContentType().isKindOf(this.getMappingFileContentType())) continue;
            return file.getFullPath();
        }
        return null;
    }

    protected IContentType getMappingFileContentType() {
        return JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE;
    }

    protected IPath convertToRuntimPath(IPath path) {
        ProjectResourceLocator locator = (ProjectResourceLocator)this.jpaProject.getProject().getAdapter(ProjectResourceLocator.class);
        return locator.getRuntimePath(path);
    }

    protected final boolean hasNoConvertibleJavaMetadata() {
        return !this.hasConvertibleJavaMetadata();
    }

    protected final boolean hasConvertibleJavaMetadata() {
        return this.persistenceUnit != null && this.hasConvertibleJavaMetadata_();
    }

    protected abstract boolean hasConvertibleJavaMetadata_();

    protected abstract String getMissingJavaMetadataWarningMessage();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label pageLabel = new Label(composite, 0);
        pageLabel.setText(JptUiMessages.JavaMetadataConversionWizardPage_label);
        pageLabel.setBounds(3, 230, 150, 12);
        Control mappingFileControl = this.createMappingFileControl(composite);
        GridData data = new GridData(768);
        data.heightHint = 58;
        data.grabExcessHorizontalSpace = true;
        mappingFileControl.setLayoutData((Object)data);
        Text noteTextField = new Text(composite, 10);
        noteTextField.setText(NLS.bind((String)JptUiMessages.JavaMetadataConversion_warning, (Object)StringTools.CR));
        noteTextField.setFont(new Font((Device)composite.getDisplay(), "Arial", 10, 0x1000000));
        noteTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.setControl((Control)composite);
        this.mappingFileNameModel.addPropertyChangeListener("value", this.buildMappingFileNameListener());
        this.setPageComplete(this.getOrmXmlResource() != null);
    }

    protected Control createMappingFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Link link = new Link(composite, 16384);
        link.setText(JptUiMessages.JavaMetadataConversionWizardPage_newMappingFileLink);
        link.setToolTipText(JptUiMessages.JavaMetadataConversionWizardPage_newMappingFileLinkToolTip);
        link.setLayoutData((Object)new GridData(32));
        link.addSelectionListener(this.buildMappingFileLinkListener());
        Text nameTextField = new Text(composite, 132);
        GridData gridData = new GridData(768);
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 486;
        gridData.heightHint = 14;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        nameTextField.setLayoutData((Object)gridData);
        SWTTools.bind(this.mappingFileNameModel, (Text)nameTextField);
        Button browseButton = new Button(composite, 0x1000000);
        browseButton.setToolTipText(JptUiMessages.JavaMetadataConversionWizardPage_mappingFileBrowseButtonToolTip);
        browseButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        browseButton.setText(JptUiMessages.JavaMetadataConversionWizardPage_mappingFileBrowseButton);
        browseButton.addSelectionListener(this.buildMappingFileBrowseButtonListener());
        return composite;
    }

    protected PropertyChangeListener buildMappingFileNameListener() {
        return new MappingFileNameListener();
    }

    protected void validate() {
        String errorMessage = this.buildErrorMessage();
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    protected String buildErrorMessage() {
        String jpaProjectVersion;
        JpaXmlResource ormXmlResource = this.getOrmXmlResource();
        if (ormXmlResource == null) {
            return JptUiMessages.JavaMetadataConversion_mappingFileDoesNotExist;
        }
        String mappingFileVersion = ormXmlResource.getVersion();
        if (Tools.valuesAreDifferent((Object)mappingFileVersion, (Object)(jpaProjectVersion = this.getJpaProjectVersion()))) {
            return NLS.bind((String)JptUiMessages.JavaMetadataConversion_mappingFileVersionIsInvalid, (Object)mappingFileVersion, (Object)jpaProjectVersion);
        }
        if (this.getEntityMappings(ormXmlResource) == null) {
            return JptUiMessages.JavaMetadataConversion_mappingFileNotListedInPersistenceXml;
        }
        if (this.noConvertibleJavaMetadata) {
            this.setMessage(this.getMissingJavaMetadataWarningMessage(), 2);
        }
        return null;
    }

    protected EntityMappings getEntityMappings() {
        return this.getEntityMappings(this.getOrmXmlResource());
    }

    protected EntityMappings getEntityMappings(JpaXmlResource ormXmlResource) {
        return ormXmlResource == null ? null : this.getEntityMappings_(ormXmlResource);
    }

    protected EntityMappings getEntityMappings_(JpaXmlResource ormXmlResource) {
        Iterator nodes = this.jpaProject.getJpaFile(ormXmlResource.getFile()).getRootStructureNodes().iterator();
        return nodes.hasNext() ? (EntityMappings)nodes.next() : null;
    }

    protected JpaXmlResource getOrmXmlResource() {
        IPath mappingFilePath = this.getMappingFilePath();
        return mappingFilePath == null ? null : this.jpaProject.getMappingFileXmlResource(mappingFilePath);
    }

    protected IPath getMappingFilePath() {
        String mappingFileName = this.getMappingFileName();
        return StringTools.stringIsEmpty((String)mappingFileName) ? null : new Path(mappingFileName);
    }

    protected String getMappingFileName() {
        String mappingFileName = (String)this.mappingFileNameModel.getValue();
        return StringTools.stringIsEmpty((String)mappingFileName) ? null : mappingFileName;
    }

    protected String getJpaProjectVersion() {
        return this.jpaProject.getJpaPlatform().getJpaVersion().getVersion();
    }

    protected SelectionListener buildMappingFileLinkListener() {
        return new MappingFileLinkListener();
    }

    protected void mappingFileLinkPressed() {
        IPath path = this.openNewMappingFileWizard();
        if (path != null) {
            this.mappingFileNameModel.setValue((Object)path.toString());
            this.validate();
        }
    }

    protected abstract IPath openNewMappingFileWizard();

    protected SelectionListener buildMappingFileBrowseButtonListener() {
        return new MappingFileBrowseButtonListener();
    }

    protected void mappingFileBrowseButtonPressed() {
        IFile file;
        IProject project = this.jpaProject.getProject();
        SelectMappingFileDialog dialog = this.buildSelectMappingFileDialog();
        dialog.setTitle(JptUiMessages.SelectMappingFileDialog_title);
        dialog.setMessage(JptUiMessages.SelectMappingFileDialog_message);
        dialog.addFilter(this.buildSelectMappingFileDialogViewerFilter());
        dialog.setInput(project);
        JpaXmlResource resource = this.getOrmXmlResource();
        IFile iFile = file = resource == null ? null : resource.getFile();
        if (file != null) {
            dialog.setInitialSelection(file);
        }
        if (dialog.open() == 0) {
            this.mappingFileNameModel.setValue((Object)dialog.getChosenName());
            this.validate();
        }
    }

    protected abstract SelectMappingFileDialog buildSelectMappingFileDialog();

    protected ViewerFilter buildSelectMappingFileDialogViewerFilter() {
        return new XmlMappingFileViewerFilter(this.jpaProject, this.getMappingFileContentType());
    }

    protected boolean performFinish() {
        return this.isOKToConvert() && this.performFinish_();
    }

    protected boolean isOKToConvert() {
        return this.hasConvertibleJavaMetadata();
    }

    protected boolean performFinish_() {
        try {
            this.buildProgressMonitorDialog().run(true, true, this.buildConversionRunnable());
        }
        catch (InvocationTargetException ex) {
            JptJpaUiPlugin.log(ex);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    protected ProgressMonitorDialog buildProgressMonitorDialog() {
        return new ProgressMonitorDialog(this.getShell());
    }

    protected IRunnableWithProgress buildConversionRunnable() {
        return new ConversionRunnable(this.getConversionCommandStrategy(), this.getEntityMappings());
    }

    protected abstract ConversionCommand.Strategy getConversionCommandStrategy();

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(HELP_CONTEXT_ID);
    }

    protected static class ConversionCommand
    implements Command {
        protected final Strategy strategy;
        protected final EntityMappings entityMappings;
        protected final IProgressMonitor monitor;

        protected ConversionCommand(Strategy strategy, EntityMappings entityMappings, IProgressMonitor monitor) {
            if (strategy == null || entityMappings == null || monitor == null) {
                throw new NullPointerException();
            }
            this.strategy = strategy;
            this.entityMappings = entityMappings;
            this.monitor = monitor;
        }

        public void execute() {
            this.strategy.execute(this.entityMappings, this.monitor);
            this.getOrmXmlResource().save();
            this.saveAllFiles();
            this.openEditorOnMappingFile();
        }

        protected JpaXmlResource getOrmXmlResource() {
            return this.entityMappings.getParent().getXmlResource();
        }

        protected void saveAllFiles() {
            SWTUtil.asyncExec((Runnable)this.buildSaveAllFilesRunnable());
        }

        protected Runnable buildSaveAllFilesRunnable() {
            return new SaveFilesRunnable(this.getProject());
        }

        protected IProject getProject() {
            return this.entityMappings.getJpaProject().getProject();
        }

        protected void openEditorOnMappingFile() {
            SWTUtil.asyncExec((Runnable)this.buildOpenEditorOnMappingFileRunnable());
        }

        protected Runnable buildOpenEditorOnMappingFileRunnable() {
            return new OpenEditorRunnable(this.getOrmXmlResource().getFile());
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.entityMappings.getPersistenceUnit());
        }

        public static interface Strategy {
            public void execute(EntityMappings var1, IProgressMonitor var2);
        }
    }

    protected static class ConversionRunnable
    implements IRunnableWithProgress {
        protected final ConversionCommand.Strategy conversionCommandStrategy;
        protected final EntityMappings entityMappings;

        protected ConversionRunnable(ConversionCommand.Strategy conversionCommandStrategy, EntityMappings entityMappings) {
            if (conversionCommandStrategy == null || entityMappings == null) {
                throw new NullPointerException();
            }
            this.conversionCommandStrategy = conversionCommandStrategy;
            this.entityMappings = entityMappings;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = ws.getRuleFactory().modifyRule((IResource)ws.getRoot());
            try {
                ws.run(this.buildWorkspaceRunnable(), rule, 1, monitor);
            }
            catch (CoreException ex) {
                if (ex.getStatus().getSeverity() == 8) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(ex);
            }
        }

        protected void run_(IProgressMonitor monitor) {
            ConversionCommand conversionCommand = new ConversionCommand(this.conversionCommandStrategy, this.entityMappings, monitor);
            try {
                this.getJpaProjectManager().execute((Command)conversionCommand, SynchronousUiCommandExecutor.instance());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new OperationCanceledException();
            }
        }

        protected IWorkspaceRunnable buildWorkspaceRunnable() {
            return new WorkspaceRunnable();
        }

        protected JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        protected IWorkspace getWorkspace() {
            return this.entityMappings.getParent().getXmlResource().getFile().getWorkspace();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }

        protected class WorkspaceRunnable
        extends WorkspaceRunnableAdapter {
            protected WorkspaceRunnable() {
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                ConversionRunnable.this.run_(monitor);
            }
        }
    }

    protected class MappingFileBrowseButtonListener
    extends SelectionAdapter {
        protected MappingFileBrowseButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            JavaMetadataConversionWizardPage.this.mappingFileBrowseButtonPressed();
        }
    }

    protected class MappingFileLinkListener
    extends SelectionAdapter {
        protected MappingFileLinkListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            JavaMetadataConversionWizardPage.this.mappingFileLinkPressed();
        }
    }

    protected class MappingFileNameListener
    extends PropertyChangeAdapter {
        protected MappingFileNameListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JavaMetadataConversionWizardPage.this.validate();
        }
    }

    protected static class OpenEditorRunnable
    implements Runnable {
        protected final IFile file;

        protected OpenEditorRunnable(IFile file) {
            if (file == null) {
                throw new NullPointerException();
            }
            this.file = file;
        }

        public void run() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)this.file);
            }
            catch (PartInitException ex) {
                JptJpaUiPlugin.log(ex);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.file);
        }
    }

    protected static class SaveFilesRunnable
    implements Runnable {
        protected final IResource[] resourceRoots;

        protected SaveFilesRunnable(IProject project) {
            if (project == null) {
                throw new NullPointerException();
            }
            this.resourceRoots = new IResource[]{project};
        }

        public void run() {
            IDE.saveAllEditors((IResource[])this.resourceRoots, (boolean)false);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.resourceRoots[0]);
        }
    }
}

