/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dnd.ILocalDropHandler;

public class RegistryReader {
    private static final Logger _log = PDPlugin.getLogger(RegistryReader.class);
    private static ILocalDropHandler[] _handlers = null;

    public static synchronized ILocalDropHandler[] getAllHandlers() {
        if (_handlers == null) {
            _handlers = RegistryReader.readAllHandlers();
        }
        return _handlers;
    }

    private static ILocalDropHandler[] readAllHandlers() {
        ArrayList<Object> result = new ArrayList<Object>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] dropHandlers = ext.getConfigurationElements();
            int j = 0;
            while (j < dropHandlers.length) {
                if (dropHandlers[j].getName().equals("localDropHandler")) {
                    dropHandlers[j].getAttribute("class");
                    try {
                        Object obj = dropHandlers[j].createExecutableExtension("class");
                        if (obj instanceof ILocalDropHandler) {
                            result.add(obj);
                        }
                    }
                    catch (CoreException e) {
                        _log.info("CoreException", (Throwable)e);
                    }
                }
                ++j;
            }
            ++i;
        }
        ILocalDropHandler[] ret = new ILocalDropHandler[result.size()];
        result.toArray(ret);
        return ret;
    }
}

