/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationListIterator;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListIteratorTests
extends TestCase {
    static final Transformer<String, Integer> STRING_LENGTH_TRANSFORMER = new StringLengthTransformer();
    static final Transformer<Object, Integer> OBJECT_STRING_LENGTH_TRANSFORMER = new ObjectStringLengthTransformer();

    public TransformationListIteratorTests(String name) {
        super(name);
    }

    public void testHasNextAndHasPrevious() {
        int i = 0;
        ListIterator<Integer> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationListIteratorTests.assertEquals((int)8, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        TransformationListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testHasNextAndHasPreviousUpcast() {
        int i = 0;
        ListIterator<Object> stream = this.buildIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationListIteratorTests.assertEquals((int)8, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        TransformationListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNextAndPrevious() {
        int i = 0;
        ListIterator<Integer> stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((int)(++i), (int)stream.next());
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((int)(--i), (int)stream.previous());
        }
    }

    public void testNextIndexAndPreviousIndex() {
        int i = -1;
        ListIterator<Integer> stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((int)(++i), (int)stream.nextIndex());
            stream.next();
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((int)(--i), (int)stream.previousIndex());
            stream.previous();
        }
    }

    public void testRemove() {
        List<String> l = this.buildList();
        ListIterator<Integer> stream = this.buildTransformationListIterator(l.listIterator(), STRING_LENGTH_TRANSFORMER);
        while (stream.hasNext()) {
            if (stream.next() != 3) continue;
            stream.remove();
        }
        TransformationListIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildList().size() - 1), (int)l.size());
        TransformationListIteratorTests.assertFalse((String)"element still in list", (boolean)l.contains("333"));
        TransformationListIteratorTests.assertTrue((String)"wrong element removed", (boolean)l.contains("22"));
    }

    public void testUnsupportedOperationExceptionOnAdd() {
        ListIterator<Integer> stream = this.buildIterator();
        boolean exCaught = false;
        try {
            stream.add(new Integer(0));
            TransformationListIteratorTests.fail((String)"exception not thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionOnSet() {
        ListIterator<Integer> stream = this.buildIterator();
        boolean exCaught = false;
        try {
            stream.set(new Integer(0));
            TransformationListIteratorTests.fail((String)"exception not thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator<Integer> stream = this.buildIterator();
        Integer integer = null;
        while (stream.hasNext()) {
            integer = stream.next();
        }
        try {
            integer = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + integer), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        ListIterator<Integer> stream = this.buildUnmodifiableIterator();
        while (stream.hasNext()) {
            int i = (Integer)stream.next();
            if (i != 3) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        TransformationListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalStateException() {
        boolean exCaught = false;
        try {
            this.buildIterator().remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    private ListIterator<Integer> buildIterator() {
        return this.buildTransformationListIterator(this.buildNestedIterator(), STRING_LENGTH_TRANSFORMER);
    }

    private ListIterator<Object> buildIteratorUpcast() {
        return this.buildTransformationListIteratorUpcast(this.buildNestedIterator(), OBJECT_STRING_LENGTH_TRANSFORMER);
    }

    private ListIterator<Integer> buildUnmodifiableIterator() {
        return this.buildTransformationListIterator(this.buildUnmodifiableNestedIterator(), STRING_LENGTH_TRANSFORMER);
    }

    private ListIterator<Integer> buildTransformationListIterator(ListIterator<String> nestedIterator, Transformer<String, Integer> transformer) {
        return new TransformationListIterator(nestedIterator, transformer);
    }

    private ListIterator<Object> buildTransformationListIteratorUpcast(ListIterator<String> nestedIterator, Transformer<Object, Integer> transformer) {
        return new TransformationListIterator(nestedIterator, transformer);
    }

    private ListIterator<String> buildNestedIterator() {
        return this.buildList().listIterator();
    }

    private ListIterator<String> buildUnmodifiableNestedIterator() {
        return this.buildUnmodifiableList().listIterator();
    }

    private List<String> buildList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        l.add("22");
        l.add("333");
        l.add("4444");
        l.add("55555");
        l.add("666666");
        l.add("7777777");
        l.add("88888888");
        return l;
    }

    private List<String> buildUnmodifiableList() {
        return Collections.unmodifiableList(this.buildList());
    }

    public void testInvalidTransformationListIterator() {
        TransformationListIterator iterator = new TransformationListIterator(this.buildList().listIterator(), DisabledTransformer.instance());
        boolean exCaught = false;
        try {
            Integer integer = (Integer)iterator.next();
            TransformationListIteratorTests.fail((String)("invalid integer: " + integer));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectStringLengthTransformer
    extends TransformerAdapter<Object, Integer> {
        ObjectStringLengthTransformer() {
        }

        public Integer transform(Object input) {
            return new Integer(((String)input).length());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringLengthTransformer
    extends TransformerAdapter<String, Integer> {
        StringLengthTransformer() {
        }

        public Integer transform(String s) {
            return new Integer(s.length());
        }
    }
}

