/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedList;

public class CompositeListValueModelTests
extends TestCase {
    private LocalListValueModel<String> lvm0;
    private LocalListValueModel<String> lvm1;
    private LocalListValueModel<String> lvm2;
    private LocalListValueModel<String> lvm3;
    private LocalListValueModel<LocalListValueModel<String>> uberLVM;
    private CompositeListValueModel<LocalListValueModel<String>, String> compositeLVM;

    public CompositeListValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.lvm0 = new LocalListValueModel();
        this.lvm0.add("aaa");
        this.lvm0.add("bbb");
        this.lvm0.add("ccc");
        this.lvm1 = new LocalListValueModel();
        this.lvm1.add("ddd");
        this.lvm1.add("eee");
        this.lvm2 = new LocalListValueModel();
        this.lvm2.add("fff");
        this.lvm3 = new LocalListValueModel();
        this.lvm3.add("ggg");
        this.lvm3.add("hhh");
        this.lvm3.add("iii");
        this.lvm3.add("jjj");
        this.lvm3.add("kkk");
        this.uberLVM = new LocalListValueModel();
        this.uberLVM.add(this.lvm0);
        this.uberLVM.add(this.lvm1);
        this.uberLVM.add(this.lvm2);
        this.uberLVM.add(this.lvm3);
        this.compositeLVM = CompositeListValueModel.forModels(this.uberLVM);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetInt() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)this.compositeLVM.get(0)));
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)coordList.get(0)));
        CompositeListValueModelTests.assertEquals((String)"bbb", (String)((String)this.compositeLVM.get(1)));
        CompositeListValueModelTests.assertEquals((String)"bbb", (String)((String)coordList.get(1)));
        CompositeListValueModelTests.assertEquals((String)"ccc", (String)((String)this.compositeLVM.get(2)));
        CompositeListValueModelTests.assertEquals((String)"ccc", (String)((String)coordList.get(2)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)coordList.get(4)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testIterator() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)this.compositeLVM.iterator().next()));
        CompositeListValueModelTests.assertEquals((String)"aaa", (String)((String)coordList.iterator().next()));
        Iterator stream1 = coordList.iterator();
        Iterator stream2 = this.compositeLVM.iterator();
        while (stream2.hasNext()) {
            CompositeListValueModelTests.assertEquals((String)((String)stream1.next()), (String)((String)stream2.next()));
        }
        CompositeListValueModelTests.assertFalse((boolean)stream1.hasNext());
    }

    public void testSize() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertEquals((int)11, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)11, (int)coordList.size());
    }

    public void testToArray() {
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
    }

    public void testHasListeners() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        CompositeListValueModelTests.assertTrue((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertTrue((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
        this.compositeLVM.removeListChangeListener("list values", coordList);
        CompositeListValueModelTests.assertFalse((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertFalse((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
        this.compositeLVM.addListChangeListener("list values", coordList);
        CompositeListValueModelTests.assertTrue((boolean)this.compositeLVM.hasAnyListChangeListeners("list values"));
        CompositeListValueModelTests.assertTrue((boolean)this.lvm0.hasAnyListChangeListeners("list values"));
    }

    public void testAddSource_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        LocalListValueModel lvm = new LocalListValueModel();
        lvm.add("xxx");
        lvm.add("yyy");
        lvm.add("zzz");
        this.uberLVM.add(0, (Object)lvm);
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddSource_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        LocalListValueModel lvm = new LocalListValueModel();
        lvm.add("xxx");
        lvm.add("yyy");
        lvm.add("zzz");
        this.uberLVM.add(2, (Object)lvm);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddSource_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        LocalListValueModel lvm = new LocalListValueModel();
        lvm.add("xxx");
        lvm.add("yyy");
        lvm.add("zzz");
        this.uberLVM.add((Object)lvm);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testAddSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        LocalListValueModel lvmA = new LocalListValueModel();
        lvmA.add("xxx");
        lvmA.add("yyy");
        lvmA.add("zzz");
        LocalListValueModel lvmB = new LocalListValueModel();
        lvmB.add("ppp");
        lvmB.add("qqq");
        lvmB.add("rrr");
        ArrayList c = new ArrayList();
        c.add(lvmA);
        c.add(lvmB);
        this.uberLVM.addAll(2, c);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "ppp", "qqq", "rrr", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(12)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(12)));
    }

    public void testRemoveSource_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(0);
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testRemoveSource_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveSource_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testRemoveSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.remove(2, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"eee", (String)((String)coordList.get(4)));
    }

    public void testReplaceSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        LocalListValueModel lvmA = new LocalListValueModel();
        lvmA.add("xxx");
        lvmA.add("yyy");
        lvmA.add("zzz");
        LocalListValueModel lvmB = new LocalListValueModel();
        lvmB.add("ppp");
        lvmB.add("qqq");
        lvmB.add("rrr");
        ArrayList list = new ArrayList();
        list.add(lvmA);
        list.add(lvmB);
        this.uberLVM.set(2, list);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "yyy", "zzz", "ppp", "qqq", "rrr"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"qqq", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"qqq", (String)((String)coordList.get(9)));
    }

    public void testMoveSources_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(0, 2, 2);
        Object[] expected = new Object[]{"fff", "ggg", "hhh", "iii", "jjj", "kkk", "aaa", "bbb", "ccc", "ddd", "eee"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(1)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(1)));
    }

    public void testMoveSources_Middle() {
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        this.uberLVM.add((Object)lvm4);
        LocalListValueModel lvm5 = new LocalListValueModel();
        lvm5.add("nnn");
        lvm5.add("ooo");
        lvm5.add("ppp");
        lvm5.add("qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(1, 3, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm", "ddd", "eee", "fff", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testMoveSources_End() {
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        this.uberLVM.add((Object)lvm4);
        LocalListValueModel lvm5 = new LocalListValueModel();
        lvm5.add("nnn");
        lvm5.add("ooo");
        lvm5.add("ppp");
        lvm5.add("qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(3, 0, 3);
        Object[] expected = new Object[]{"ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm", "nnn", "ooo", "ppp", "qqq", "aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(0)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(0)));
    }

    public void testMoveSource() {
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        this.uberLVM.add((Object)lvm4);
        LocalListValueModel lvm5 = new LocalListValueModel();
        lvm5.add("nnn");
        lvm5.add("ooo");
        lvm5.add("ppp");
        lvm5.add("qqq");
        this.uberLVM.add((Object)lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.move(3, 1);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "ddd", "eee", "lll", "mmm", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)this.compositeLVM.get(14)));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)coordList.get(14)));
    }

    public void testClearSources() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.clear();
        Object[] expected = new Object[]{};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
    }

    public void testChangeSources1() {
        ArrayList newList = new ArrayList();
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        newList.add(lvm4);
        LocalListValueModel lvm5 = new LocalListValueModel();
        lvm5.add("nnn");
        lvm5.add("ooo");
        lvm5.add("ppp");
        lvm5.add("qqq");
        newList.add(lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.setListValues(newList);
        Object[] expected = new Object[]{"lll", "mmm", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)coordList.get(3)));
    }

    public void testChangeSources2() {
        ArrayList newList = new ArrayList();
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        newList.add(lvm4);
        LocalListValueModel lvm5 = new LocalListValueModel();
        lvm5.add("nnn");
        lvm5.add("ooo");
        lvm5.add("ppp");
        lvm5.add("qqq");
        newList.add(lvm5);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.changeListValues(newList);
        Object[] expected = new Object[]{"lll", "mmm", "nnn", "ooo", "ppp", "qqq"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ooo", (String)((String)coordList.get(3)));
    }

    public void testChangeSources3() {
        ErrorListener listener = new ErrorListener();
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        ArrayList<LocalListValueModel<String>> newList = new ArrayList<LocalListValueModel<String>>();
        newList.add(this.lvm0);
        newList.add(this.lvm1);
        newList.add(this.lvm2);
        newList.add(this.lvm3);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.changeListValues(newList);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
    }

    public void testChangeSources4() {
        ErrorListener listener = new ErrorListener(){

            public void itemsAdded(ListAddEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        ArrayList newList = new ArrayList();
        newList.add(this.lvm0);
        newList.add(this.lvm1);
        newList.add(this.lvm2);
        newList.add(this.lvm3);
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        newList.add(lvm4);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.changeListValues(newList);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
    }

    public void testChangeSources5() {
        ErrorListener listener = new ErrorListener(){

            public void itemsRemoved(ListRemoveEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        ArrayList<LocalListValueModel<String>> newList = new ArrayList<LocalListValueModel<String>>();
        newList.add(this.lvm0);
        newList.add(this.lvm1);
        newList.add(this.lvm2);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.changeListValues(newList);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
    }

    public void testChangeSources6() {
        ErrorListener listener = new ErrorListener(){

            public void itemsAdded(ListAddEvent event) {
            }

            public void itemsRemoved(ListRemoveEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        ArrayList newList = new ArrayList();
        newList.add(this.lvm0);
        newList.add(this.lvm1);
        LocalListValueModel lvm4 = new LocalListValueModel();
        lvm4.add("lll");
        lvm4.add("mmm");
        newList.add(lvm4);
        newList.add(this.lvm3);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.uberLVM.changeListValues(newList);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "lll", "mmm", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ddd", (String)((String)coordList.get(3)));
    }

    public void testAddItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.add(0, "xxx");
        Object[] expected = new Object[]{"xxx", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testAddItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.add(1, "xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testAddItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.add(5, "xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testAddItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.addAll(0, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.addAll(1, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "yyy", "zzz", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testAddItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.addAll(5, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testRemoveItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.remove(0);
        Object[] expected = new Object[]{"bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.remove(0);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(5)));
    }

    public void testRemoveItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(4);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testRemoveItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.remove(0, 3);
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testRemoveItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(1, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)coordList.get(7)));
    }

    public void testRemoveItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.remove(3, 2);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.set(0, "xxx");
        Object[] expected = new Object[]{"xxx", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm2.set(0, "xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(4, "xxx");
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "xxx"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.set(0, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testReplaceItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(1, Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "xxx", "yyy", "zzz", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)this.compositeLVM.get(10)));
        CompositeListValueModelTests.assertEquals((String)"kkk", (String)((String)coordList.get(10)));
    }

    public void testReplaceItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.set(3, Arrays.asList("xxx", "yyy"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "xxx", "yyy"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.move(2, 0);
        Object[] expected = new Object[]{"bbb", "ccc", "aaa", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.move(0, 1);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "eee", "ddd", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItem_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.move(0, 4);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "kkk", "ggg", "hhh", "iii", "jjj"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testMoveItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.move(1, 0, 2);
        Object[] expected = new Object[]{"ccc", "aaa", "bbb", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testMoveItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.add("eee.1");
        this.lvm1.add("eee.2");
        this.lvm1.add("eee.3");
        this.lvm1.move(1, 2, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee.1", "eee.2", "eee.3", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testMoveItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.move(0, 2, 3);
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "iii", "jjj", "kkk", "ggg", "hhh"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(9)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(9)));
    }

    public void testClearItems_Begin() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.clear();
        Object[] expected = new Object[]{"ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(3)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(3)));
    }

    public void testClearItems_Middle() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.clear();
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(4)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(4)));
    }

    public void testClearItems_End() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.clear();
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin1() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.setListValues(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"xxx", "yyy", "zzz", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle1() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.setListValues(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "xxx", "yyy", "zzz", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End1() {
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.setListValues(Arrays.asList("xxx", "yyy", "zzz"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "xxx", "yyy", "zzz"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin2() {
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)new ErrorListener());
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.changeListValues(Arrays.asList("aaa", "bbb", "ccc"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle2() {
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)new ErrorListener());
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.changeListValues(Arrays.asList("ddd", "eee"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"hhh", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"hhh", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End2() {
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)new ErrorListener());
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.changeListValues(Arrays.asList("ggg", "hhh", "iii", "jjj", "kkk"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin3() {
        ErrorListener listener = new ErrorListener(){

            public void itemsReplaced(ListReplaceEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.changeListValues(Arrays.asList("aaa", "bbb", "xxx"));
        Object[] expected = new Object[]{"aaa", "bbb", "xxx", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle3() {
        ErrorListener listener = new ErrorListener(){

            public void itemsReplaced(ListReplaceEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.changeListValues(Arrays.asList("ddd", "xxx"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "xxx", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"hhh", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"hhh", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End3() {
        ErrorListener listener = new ErrorListener(){

            public void itemsReplaced(ListReplaceEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.changeListValues(Arrays.asList("ggg", "hhh", "iii", "xxx", "kkk"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "xxx", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin4() {
        ErrorListener listener = new ErrorListener(){

            public void itemsAdded(ListAddEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.changeListValues(Arrays.asList("aaa", "bbb", "ccc", "xxx"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "xxx", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle4() {
        ErrorListener listener = new ErrorListener(){

            public void itemsAdded(ListAddEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.changeListValues(Arrays.asList("ddd", "eee", "xxx"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "xxx", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"ggg", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End4() {
        ErrorListener listener = new ErrorListener(){

            public void itemsAdded(ListAddEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.changeListValues(Arrays.asList("ggg", "hhh", "iii", "jjj", "kkk", "xxx"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "xxx"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    public void testChangeItems_Begin5() {
        ErrorListener listener = new ErrorListener(){

            public void itemsRemoved(ListRemoveEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm0.changeListValues(Arrays.asList("aaa"));
        Object[] expected = new Object[]{"aaa", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"iii", (String)((String)this.compositeLVM.get(6)));
        CompositeListValueModelTests.assertEquals((String)"iii", (String)((String)coordList.get(6)));
    }

    public void testChangeItems_Middle5() {
        ErrorListener listener = new ErrorListener(){

            public void itemsRemoved(ListRemoveEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm1.changeListValues(Arrays.asList("ddd"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"iii", (String)((String)this.compositeLVM.get(7)));
        CompositeListValueModelTests.assertEquals((String)"iii", (String)((String)coordList.get(7)));
    }

    public void testChangeItems_End5() {
        ErrorListener listener = new ErrorListener(){

            public void itemsRemoved(ListRemoveEvent event) {
            }
        };
        this.compositeLVM.addListChangeListener("list values", (ListChangeListener)listener);
        CoordinatedList coordList = new CoordinatedList(this.compositeLVM);
        this.lvm3.changeListValues(Arrays.asList("ggg", "hhh", "iii"));
        Object[] expected = new Object[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii"};
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)this.compositeLVM.size());
        CompositeListValueModelTests.assertEquals((int)expected.length, (int)coordList.size());
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, this.compositeLVM.toArray()));
        CompositeListValueModelTests.assertTrue((boolean)Arrays.equals(expected, coordList.toArray()));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)this.compositeLVM.get(5)));
        CompositeListValueModelTests.assertEquals((String)"fff", (String)((String)coordList.get(5)));
    }

    class ErrorListener
    implements ListChangeListener {
        ErrorListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            CompositeListValueModelTests.fail();
        }

        public void itemsRemoved(ListRemoveEvent event) {
            CompositeListValueModelTests.fail();
        }

        public void itemsMoved(ListMoveEvent event) {
            CompositeListValueModelTests.fail();
        }

        public void itemsReplaced(ListReplaceEvent event) {
            CompositeListValueModelTests.fail();
        }

        public void listCleared(ListClearEvent event) {
            CompositeListValueModelTests.fail();
        }

        public void listChanged(ListChangeEvent event) {
            CompositeListValueModelTests.fail();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocalListValueModel<E>
    extends SimpleListValueModel<E> {
        LocalListValueModel() {
        }

        void changeListValues(Iterable<E> listValues) {
            if (listValues == null) {
                throw new NullPointerException();
            }
            this.list.clear();
            CollectionTools.addAll((Collection)this.list, listValues);
            this.fireListChanged("list values", this.list);
        }
    }
}

