/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDEnumerationFacetAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;

public class AddEnumerationsCommand
extends BaseCommand {
    XSDSimpleTypeDefinition simpleType;
    String value;
    private int index = -1;
    private String addEnumerationLocation;

    public AddEnumerationsCommand(String label, XSDSimpleTypeDefinition simpleType) {
        super(label);
        this.simpleType = simpleType;
    }

    public AddEnumerationsCommand(String label, XSDSimpleTypeDefinition simpleType, String ID, int index) {
        super(label);
        this.simpleType = simpleType;
        this.index = index;
        this.addEnumerationLocation = ID;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.simpleType.getElement());
            XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
            XSDEnumerationFacet enumerationFacet = factory.createXSDEnumerationFacet();
            enumerationFacet.setLexicalValue(this.value);
            this.index = this.getInsertionIndex();
            EList facets = this.simpleType.getFacetContents();
            if (this.index >= 0 && this.index < facets.size()) {
                facets.add(this.index, enumerationFacet);
            } else {
                facets.add(enumerationFacet);
            }
            this.formatChild(this.simpleType.getElement());
            this.addedXSDConcreteComponent = enumerationFacet;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.endRecording();
    }

    protected int getInsertionIndex() {
        if (this.index < 0) {
            return -1;
        }
        if (this.addEnumerationLocation.equals(AddXSDEnumerationFacetAction.BEFORE_SELECTED_ID)) {
            return this.index;
        }
        if (this.addEnumerationLocation.equals(AddXSDEnumerationFacetAction.AFTER_SELECTED_ID)) {
            ++this.index;
            return this.index;
        }
        return -1;
    }
}

