/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.structure;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeAnonymousTypeGlobalCommand;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDTypeDefinition;

public class MakeTypeGlobalChange
extends Change {
    private Map fChanges;
    private String fNewName;
    private XSDTypeDefinition fTypeComponent;

    public MakeTypeGlobalChange(XSDTypeDefinition component, String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        this.fTypeComponent = component;
        this.fNewName = newName;
    }

    protected Change createUndoChange() {
        return new MakeTypeGlobalChange(this.fTypeComponent, this.getNewName());
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        this.performModify(this.getNewName());
    }

    public void performModify(String value) {
    }

    public TextChange getChange(IFile file) {
        TextChange result = (TextChange)this.fChanges.get(file);
        if (result == null) {
            result = new TextFileChange(file.getName(), file);
            this.fChanges.put(file, result);
        }
        return result;
    }

    public String getName() {
        return RefactoringMessages.getFormattedString("MakeTypeGlobalChange.name", new String[]{this.getNewName()});
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        try {
            pm.beginTask(RefactoringMessages.getString("XSDComponentRenameChange.Renaming"), 1);
            Change result = this.createUndoChange();
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            change = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    protected String getNewName() {
        return this.fNewName;
    }

    public Object getModifiedElement() {
        return this.fTypeComponent;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    protected static class DelayedRenameRunnable
    implements Runnable {
        protected XSDTypeDefinition component;
        protected String name;

        public DelayedRenameRunnable(XSDTypeDefinition component, String name) {
            this.component = component;
            this.name = name;
        }

        public void run() {
            DocumentImpl doc = (DocumentImpl)this.component.getElement().getOwnerDocument();
            doc.getModel().beginRecording((Object)this, RefactoringMessages.getString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"));
            MakeAnonymousTypeGlobalCommand command = new MakeAnonymousTypeGlobalCommand((XSDConcreteComponent)this.component, this.name);
            command.run();
            doc.getModel().endRecording((Object)this);
        }
    }
}

