/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterClassConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.NamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseLinkJavaConverterClassConverter<A extends NamedConverterAnnotation>
extends EclipseLinkJavaConverter<A>
implements EclipseLinkConverterClassConverter {
    private String converterClass;

    public EclipseLinkJavaConverterClassConverter(EclipseLinkJavaConverterContainer parent, A converterAnnotation, String converterClass) {
        super(parent, converterAnnotation);
        this.converterClass = converterClass;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(this.getAnnotationConverterClass());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setAnnotationConverterClass(converterClass);
        this.setConverterClass_(converterClass);
    }

    protected void setConverterClass_(String converterClass) {
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    protected abstract String getAnnotationConverterClass();

    protected abstract void setAnnotationConverterClass(String var1);

    protected boolean typeExists(String typeName) {
        return typeName != null && JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)typeName) != null;
    }

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && TypeTools.isSubType((String)typeName, (String)interfaceName, (IJavaProject)this.getJavaProject());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverterClass(messages);
    }

    protected void validateConverterClass(List<IMessage> messages) {
        if (this.converterClass == null) {
            return;
        }
        if (StringTools.isBlank((String)this.converterClass)) {
            messages.add(this.buildValidationMessage(this.getConverterClassTextRange(), JptJpaEclipseLinkCoreValidationMessages.CONVERTER_CLASS_DEFINED));
            return;
        }
        if (!this.converterClassExists()) {
            this.addConverterClassDoesNotExistMessageTo(messages);
            return;
        }
        if (!this.converterClassImplementsInterface(this.getEclipseLinkConverterInterface())) {
            messages.add(this.buildValidationMessage(this.getConverterClassTextRange(), this.getEclipseLinkConverterInterfaceErrorMessage(), new Object[]{this.getFullyQualifiedConverterClass()}));
        }
    }

    protected void addConverterClassDoesNotExistMessageTo(List<IMessage> messages) {
        messages.add(this.buildValidationMessage(this.getConverterClassTextRange(), JptJpaEclipseLinkCoreValidationMessages.CONVERTER_CLASS_EXISTS, new Object[]{this.getFullyQualifiedConverterClass()}));
    }

    protected abstract String getEclipseLinkConverterInterface();

    protected abstract ValidationMessage getEclipseLinkConverterInterfaceErrorMessage();

    protected boolean converterClassExists() {
        return this.typeExists(this.getFullyQualifiedConverterClass());
    }

    protected boolean converterClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.getFullyQualifiedConverterClass(), interfaceName);
    }

    protected TextRange getConverterClassTextRange() {
        return this.getValidationTextRange(this.getAnnotationConverterClassTextRange());
    }

    protected abstract TextRange getAnnotationConverterClassTextRange();

    @Override
    public boolean isEquivalentTo(JpaNamedContextModel node) {
        return super.isEquivalentTo(node) && this.isEquivalentTo((EclipseLinkConverterClassConverter)node);
    }

    protected boolean isEquivalentTo(EclipseLinkConverterClassConverter converter) {
        return ObjectTools.equals((Object)this.getFullyQualifiedConverterClass(), (Object)converter.getFullyQualifiedConverterClass());
    }
}

