/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.ArrayList;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.jpa.annotate.mapping.BasicEntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.IdEntityPropertyElement;
import org.eclipse.jpt.jpa.annotate.mapping.JavaMapper;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.BasicAnnotationDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.ClassMappingPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.IdAnnotationDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JavaClassMapping;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JpaMakePersistentWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class PropsMappingPage
extends WizardPage {
    final JpaProject jpaProject;
    final ResourceManager resourceManager;
    private JavaClassMapping[] javaClassMappings;
    private ClassMappingPage classMappingPage;
    private TreeViewer mappingTreeViewer;
    private Button editBtn;
    private Button removeBtn;
    private static final int JAVA_CLASS_COLUMN_WIDTH = 130;
    private static final int PROPERTY_NAME_COLUMN_WIDTH = 110;
    private static final int PROPERTY_TYPE_COLUMN_WIDTH = 130;
    private static final int PROPERTY_DATABASE_COLUMN_WIDTH = 140;
    private static final int PROPERTY_COLUMN_TYPE_WIDTH = 100;
    private static final int MAPPING_TABLE_HEIGHT = 80;
    private static final int JAVA_CLASS_COLUMN_INDEX = 0;
    private static final int NAME_COLUMN_INDEX = 1;
    private static final int TYPE_COLUMN_INDEX = 2;
    private static final int DATABASE_COLUMN_INDEX = 3;
    private static final int COLUMN_TYPE_INDEX = 4;

    public PropsMappingPage(JpaProject proj, JavaClassMapping[] javaClassMappings, ResourceManager resourceManager, ClassMappingPage classMappingPage) {
        super("Class Mapping Properties");
        this.resourceManager = resourceManager;
        this.jpaProject = proj;
        this.javaClassMappings = javaClassMappings;
        this.classMappingPage = classMappingPage;
        this.setTitle(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_TITLE);
        this.setMessage(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_DESC);
        this.classMappingPage.addListener(new ClassMappingPage.Listener(){

            public void classMappingChanged(JavaClassMapping javaClassMapping) {
                PropsMappingPage.this.handleClassMappingChange(javaClassMapping);
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_LABEL);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createMappingTable(composite);
        this.createMappingButtons(composite);
        this.updateMappingButtons();
        this.setControl((Control)composite);
    }

    private void createMappingTable(Composite parent) {
        Tree mappingTree = new Tree(parent, 68356);
        mappingTree.setHeaderVisible(true);
        mappingTree.setLinesVisible(true);
        this.mappingTreeViewer = new TreeViewer(mappingTree);
        TreeColumn column1 = new TreeColumn(mappingTree, 16384);
        column1.setAlignment(16384);
        column1.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_JAVA_CLASS_LABEL);
        column1.setWidth(130);
        TreeColumn column2 = new TreeColumn(mappingTree, 131072);
        column2.setAlignment(16384);
        column2.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_PROPERTY_NAME_LABEL);
        column2.setWidth(110);
        TreeColumn column3 = new TreeColumn(mappingTree, 131072);
        column3.setAlignment(16384);
        column3.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_PROPERTY_TYPE_LABEL);
        column3.setWidth(130);
        TreeColumn column4 = new TreeColumn(mappingTree, 131072);
        column4.setAlignment(16384);
        column4.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_DATABASE_COLUMN);
        column4.setWidth(140);
        TreeColumn column5 = new TreeColumn(mappingTree, 131072);
        column5.setAlignment(16384);
        column5.setText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_COLUMN_TYPE);
        column5.setWidth(100);
        GridData gd = new GridData(1808);
        gd.widthHint = 610;
        gd.heightHint = 80;
        mappingTree.setLayoutData((Object)gd);
        this.mappingTreeViewer.setContentProvider((IContentProvider)new PropertiesMappingContentProvider());
        this.mappingTreeViewer.setComparator((ViewerComparator)new JpaMakePersistentWizard.TypeComparator());
        this.mappingTreeViewer.setLabelProvider((IBaseLabelProvider)new PropertiesMappingLabelProvider());
        this.mappingTreeViewer.setInput((Object)this.javaClassMappings);
        this.mappingTreeViewer.expandAll();
        mappingTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropsMappingPage.this.updateMappingButtons();
            }
        });
    }

    private void createMappingButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(2));
        this.editBtn = new Button(buttons, 0);
        this.editBtn.setImage(this.resourceManager.createImage(JptCommonUiImages.EDIT_BUTTON));
        this.editBtn.setToolTipText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_EDIT);
        this.editBtn.setLayoutData((Object)new GridData(256));
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropsMappingPage.this.editMapping();
            }
        });
        this.removeBtn = new Button(buttons, 0);
        this.removeBtn.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.removeBtn.setToolTipText(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_REMOVE);
        this.removeBtn.setLayoutData((Object)new GridData(256));
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropsMappingPage.this.removeMapping();
            }
        });
    }

    private void updateMappingButtons() {
        TreeSelection sel = (TreeSelection)this.mappingTreeViewer.getSelection();
        if (sel.getFirstElement() instanceof EntityPropertyElem) {
            this.editBtn.setEnabled(true);
            this.removeBtn.setEnabled(true);
        } else {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        }
    }

    private void editMapping() {
        int index;
        Object selectedObj = ((TreeSelection)this.mappingTreeViewer.getSelection()).getFirstElement();
        EntityPropertyElem entityProp = (EntityPropertyElem)selectedObj;
        Schema schema = this.classMappingPage.getSchema();
        JavaClassMapping classMapping = this.getClassMapping(entityProp.getClassName());
        int n = index = classMapping != null ? classMapping.getPropertyMappings().indexOf(entityProp) : -1;
        if (entityProp.getTagName().equals("id")) {
            assert (entityProp instanceof IdEntityPropertyElement);
            IdEntityPropertyElement idEntityProp = (IdEntityPropertyElement)entityProp;
            IdEntityPropertyElement idEntityPropCopy = new IdEntityPropertyElement(idEntityProp);
            IdAnnotationDialog dlg = new IdAnnotationDialog(Display.getDefault().getActiveShell(), this.resourceManager, idEntityProp.getDBTable(), (EntityPropertyElem)idEntityPropCopy);
            if (dlg.open() == 0 && index != -1) {
                classMapping.getPropertyMappings().remove(index);
                idEntityPropCopy.setUnmapped(false);
                classMapping.getPropertyMappings().add(index, (EntityPropertyElem)idEntityPropCopy);
                this.mappingTreeViewer.update((Object)idEntityPropCopy, null);
            }
        } else if (entityProp.getTagName().equals("basic")) {
            assert (entityProp instanceof BasicEntityPropertyElem);
            BasicEntityPropertyElem basicEntityProp = (BasicEntityPropertyElem)entityProp;
            BasicEntityPropertyElem basicEntityPropCopy = new BasicEntityPropertyElem(basicEntityProp);
            BasicAnnotationDialog dlg = new BasicAnnotationDialog(Display.getDefault().getActiveShell(), this.resourceManager, this.jpaProject.getProject(), entityProp.getDBTable(), (EntityPropertyElem)basicEntityPropCopy);
            if (dlg.open() == 0 && index != -1) {
                classMapping.getPropertyMappings().remove(index);
                basicEntityPropCopy.setUnmapped(false);
                classMapping.getPropertyMappings().add(index, (EntityPropertyElem)basicEntityPropCopy);
                this.mappingTreeViewer.update((Object)basicEntityPropCopy, null);
            }
        } else if (entityProp.getTagName().equals("one-to-many") || entityProp.getTagName().equals("many-to-many") || entityProp.getTagName().equals("many-to-one") || entityProp.getTagName().equals("one-to-one")) {
            assert (entityProp instanceof EntityRefPropertyElem);
            EntityRefPropertyElem refElem = (EntityRefPropertyElem)entityProp;
            EntityRefPropertyElem refElemCopy = new EntityRefPropertyElem(refElem);
            PersistenceUnit persistenceUnit = ((JpaMakePersistentWizard)this.getWizard()).getPersistenceUnit();
            AssociationAnnotationWizard wizard = new AssociationAnnotationWizard(persistenceUnit, this.resourceManager, this.jpaProject.getProject(), classMapping.getFullyQualifiedName(), schema, entityProp.getDBTable(), refElemCopy);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0 && index != -1) {
                classMapping.getPropertyMappings().remove(index);
                refElemCopy.setUnmapped(false);
                classMapping.getPropertyMappings().add(index, (EntityPropertyElem)refElemCopy);
                this.mappingTreeViewer.update((Object)refElemCopy, null);
            }
        }
    }

    private void removeMapping() {
        Object selectedObj = ((TreeSelection)this.mappingTreeViewer.getSelection()).getFirstElement();
        EntityPropertyElem entityProp = (EntityPropertyElem)selectedObj;
        entityProp.setUnmapped(true);
        this.mappingTreeViewer.update((Object)entityProp, null);
    }

    private void handleClassMappingChange(JavaClassMapping javaClassMapping) {
        javaClassMapping.clearPropertyMappings();
        Schema schema = this.classMappingPage.getSchema();
        if (schema != null && javaClassMapping.getDBTable() != null) {
            Table dbTable = schema.getTableNamed(javaClassMapping.getDBTable());
            JavaMapper javaMapper = new JavaMapper(this.jpaProject.getProject(), javaClassMapping.getFullyQualifiedName(), dbTable, javaClassMapping.getPrimaryKeyProperty());
            javaMapper.map();
            javaClassMapping.setPropertyMappings(javaMapper.getEntityProperties());
        }
        if (this.mappingTreeViewer != null) {
            this.mappingTreeViewer.getTree().removeAll();
            this.mappingTreeViewer.refresh(true);
            this.mappingTreeViewer.expandAll();
        }
    }

    private String getDBColumnDisplayStr(EntityPropertyElem propElem) {
        String colText = null;
        String tagName = propElem.getTagName();
        if (tagName.equals("id") || tagName.equals("basic")) {
            ColumnAttributes colAttrs = propElem.getColumnAnnotationAttrs();
            if (colAttrs != null) {
                colText = colAttrs.getAnnotationAttribute((String)"name").attrValue;
            }
        } else if (propElem instanceof EntityRefPropertyElem) {
            EntityRefPropertyElem refElem = (EntityRefPropertyElem)propElem;
            if (refElem.getMappedBy() != null) {
                colText = String.valueOf(JptJpaUiMakePersistentMessages.MAPPED_BY_DESC) + refElem.getMappedBy();
            } else if (refElem.getJoinTable() != null && refElem.getJoinTable().getTableName() != null) {
                colText = String.valueOf(refElem.getJoinTable().getTableName()) + " " + JptJpaUiMakePersistentMessages.JOIN_TABLE_DESC;
            } else if (refElem.getJoinColumns().size() > 0) {
                ColumnAttributes joinCol = (ColumnAttributes)refElem.getJoinColumns().get(0);
                String colName = joinCol.getName();
                String refColName = joinCol.getReferencedColumnName();
                if (colName != null && refColName != null) {
                    colText = String.format(JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_JOIN_AND, colName, refColName);
                } else if (colName != null) {
                    colText = colName;
                }
            } else if (refElem.getJoinStrategy() == JoinStrategy.PRIMARY_KEY_JOIN_COLUMNS) {
                colText = JptJpaUiMakePersistentMessages.PK_JOIN_COLUMN_DESC;
            }
        }
        return colText;
    }

    private JavaClassMapping getClassMapping(String fqClassName) {
        JavaClassMapping[] javaClassMappingArray = this.javaClassMappings;
        int n = this.javaClassMappings.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClassMapping classMapping = javaClassMappingArray[n2];
            if (classMapping.getFullyQualifiedName().equals(fqClassName)) {
                return classMapping;
            }
            ++n2;
        }
        return null;
    }

    private class PropertiesMappingContentProvider
    implements ITreeContentProvider {
        private PropertiesMappingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            JavaClassMapping[] javaClassMappings = (JavaClassMapping[])inputElement;
            ArrayList<JavaClassMapping> entityMappings = new ArrayList<JavaClassMapping>();
            JavaClassMapping[] javaClassMappingArray = javaClassMappings;
            int n = javaClassMappings.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClassMapping javaClassMapping = javaClassMappingArray[n2];
                if (javaClassMapping.getMappingKey().equals("entity")) {
                    entityMappings.add(javaClassMapping);
                }
                ++n2;
            }
            return entityMappings.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof JavaClassMapping) {
                return ((JavaClassMapping)parentElement).getPropertyMappings().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof JavaClassMapping;
        }
    }

    private class PropertiesMappingLabelProvider
    implements ITableLabelProvider {
        private final JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(2320);

        private PropertiesMappingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (!(element instanceof JavaClassMapping)) break;
                    return this.javaElementLabelProvider.getImage((Object)((JavaClassMapping)element).getJDTType());
                }
                case 1: {
                    if (!(element instanceof EntityPropertyElem)) break;
                    EntityPropertyElem propElem = (EntityPropertyElem)element;
                    Image image = null;
                    if (propElem.getTagName().equals("id")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.ID);
                    } else if (propElem.getTagName().equals("basic")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.BASIC);
                    } else if (propElem.getTagName().equals("one-to-many")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.ONE_TO_MANY);
                    } else if (propElem.getTagName().equals("many-to-many")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.MANY_TO_MANY);
                    } else if (propElem.getTagName().equals("many-to-one")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.MANY_TO_ONE);
                    } else if (propElem.getTagName().equals("one-to-one")) {
                        image = PropsMappingPage.this.resourceManager.createImage(JptJpaUiImages.ONE_TO_ONE);
                    }
                    return image;
                }
                case 2: {
                    EntityRefPropertyElem refElem;
                    if (!(element instanceof EntityRefPropertyElem) || !(refElem = (EntityRefPropertyElem)element).isEntityCollection() || refElem.getRefEntityClassName() != null) break;
                    return PropsMappingPage.this.resourceManager.createImage(JptCommonUiImages.WARNING);
                }
                case 3: {
                    String colDispStr;
                    EntityPropertyElem propElem;
                    if (!(element instanceof EntityPropertyElem) || (propElem = (EntityPropertyElem)element).isUnmapped() || (colDispStr = PropsMappingPage.this.getDBColumnDisplayStr(propElem)) != null) break;
                    return PropsMappingPage.this.resourceManager.createImage(JptCommonUiImages.WARNING);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (!(element instanceof JavaClassMapping)) break;
                    return ((JavaClassMapping)element).getJDTType().getElementName();
                }
                case 1: {
                    if (!(element instanceof EntityPropertyElem)) break;
                    EntityPropertyElem propElem = (EntityPropertyElem)element;
                    return propElem.getPropertyName();
                }
                case 2: {
                    EntityRefPropertyElem refElem;
                    if (!(element instanceof EntityPropertyElem)) break;
                    EntityPropertyElem propElem = (EntityPropertyElem)element;
                    String label = AnnotateMappingUtil.getClassName((String)propElem.getPropertyType());
                    if (propElem instanceof EntityRefPropertyElem && (refElem = (EntityRefPropertyElem)propElem).isEntityCollection() && refElem.getRefEntityClassName() == null) {
                        label = String.valueOf(label) + '<' + JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_UNSPECIFIED + '>';
                    }
                    return label;
                }
                case 3: {
                    if (!(element instanceof EntityPropertyElem)) break;
                    String colText = null;
                    EntityPropertyElem propElem = (EntityPropertyElem)element;
                    if (propElem.isUnmapped()) {
                        colText = "-";
                    } else {
                        colText = PropsMappingPage.this.getDBColumnDisplayStr(propElem);
                        if (colText == null) {
                            colText = JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_UNSPECIFIED;
                        }
                    }
                    return colText;
                }
                case 4: {
                    if (!(element instanceof EntityPropertyElem)) break;
                    EntityPropertyElem propElem = (EntityPropertyElem)element;
                    String colText = null;
                    if (propElem.isUnmapped()) {
                        colText = "-";
                    } else {
                        ColumnAttributes colAttrs = propElem.getColumnAnnotationAttrs();
                        if (colAttrs != null) {
                            Schema schema;
                            String colName = colAttrs.getAnnotationAttribute((String)"name").attrValue;
                            if (colName != null && (schema = PropsMappingPage.this.classMappingPage.getSchema()) != null && propElem.getDBColumn() != null) {
                                colText = propElem.getDBColumn().getDataTypeName();
                            }
                        } else {
                            colText = JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_COLUMN_TYPE_NA;
                        }
                    }
                    return colText;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

