/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedQueue;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

public class SWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;
    private final SynchronizedQueue<StateChangeEvent> events = new SynchronizedQueue();

    public SWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void stateChanged(StateChangeEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    void forwardEvents() {
        for (StateChangeEvent event : this.events.drain()) {
            try {
                this.listener.stateChanged(event);
            }
            catch (RuntimeException ex) {
                JptCommonUiPlugin.instance().logError(ex);
            }
        }
    }

    private void execute(Runnable r) {
        DisplayTools.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        public void run() {
            SWTStateChangeListenerWrapper.this.forwardEvents();
        }
    }
}

