/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.NotifyingRepeatingCommand;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.command.RepeatingCommandWrapper;

public class NotifyingRepeatingCommandWrapper
extends RepeatingCommandWrapper
implements NotifyingRepeatingCommand {
    private final ListenerList<NotifyingRepeatingCommand.Listener> listenerList = new ListenerList<NotifyingRepeatingCommand.Listener>(NotifyingRepeatingCommand.Listener.class);

    public NotifyingRepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
    }

    public NotifyingRepeatingCommandWrapper(Command command, CommandContext startCommandContext, ExceptionHandler exceptionHandler) {
        super(command, startCommandContext, exceptionHandler);
    }

    public void addListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.remove(listener);
    }

    void executeCommand() {
        super.executeCommand();
        if (this.state.isQuiesced()) {
            this.executionQuiesced();
        }
    }

    private void executionQuiesced() {
        for (NotifyingRepeatingCommand.Listener listener : this.listenerList.getListeners()) {
            try {
                listener.executionQuiesced(this);
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleException(ex);
            }
        }
    }
}

